#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testOrAssignInvertLevel3(void)
  {
    libecc::bitset<n> tmp1;
    tmp1 = get_x(OverLoadHook<n>());
    tmp1 |= ~get_y(OverLoadHook<m>());
    libecc::bitset<n> res = get_x(OverLoadHook<n>());
    libecc::bitset<128> tmp2 = ~get_y(OverLoadHook<m>());
    res |= tmp2;
    CPPUNIT_ASSERT( tmp1 == res );
    CPPUNIT_ASSERT( (tmp1.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
  void bitsetTest::testOrAssignInvertLevel2(void)
  {
#ifndef FASTTEST
    testOrAssignInvertLevel3<n, 13>();
    testOrAssignInvertLevel3<n, 32>();
    testOrAssignInvertLevel3<n, 45>();
    testOrAssignInvertLevel3<n, 64>();
    testOrAssignInvertLevel3<n, 77>();
    testOrAssignInvertLevel3<n, 96>();
#endif
    testOrAssignInvertLevel3<n, 109>();
#ifndef FASTTEST
    testOrAssignInvertLevel3<n, 128>();
#endif
  }

void bitsetTest::testOrAssignInvert(void)
{
#ifndef FASTTEST
  testOrAssignInvertLevel2<13>();
  testOrAssignInvertLevel2<32>();
  testOrAssignInvertLevel2<45>();
  testOrAssignInvertLevel2<64>();
  testOrAssignInvertLevel2<77>();
  testOrAssignInvertLevel2<96>();
#endif
  testOrAssignInvertLevel2<109>();
#ifndef FASTTEST
  testOrAssignInvertLevel2<128>();
#endif
}
