#define TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, m) \
  do { \
    libecc::bitset<n> x(get_x(OverLoadHook<n>())); \
    libecc::bitset<m> y(get_y(OverLoadHook<m>())); \
    libecc::bitset<m> z(get_z(OverLoadHook<m>())); \
    x OP1 INV1 y OP2 INV2 z; \
    libecc::bitset<128> tmp1(get_y(OverLoadHook<m>())); \
    libecc::bitset<128> tmp2(get_z(OverLoadHook<m>())); \
    tmp1 = INV1 tmp1; \
    tmp2 = INV2 tmp2; \
    tmp1 OP2##= tmp2; \
    libecc::bitset<n> res(get_x(OverLoadHook<n>())); \
    res OP1 tmp1; \
    CPPUNIT_ASSERT( x == res ); \
    CPPUNIT_ASSERT( (x.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 ); \
  } while(0)

#ifndef FASTTEST
#define TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, n) \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 13); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 32); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 45); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 64); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 77); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 96); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 109); \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 128);

#define TESTTRIOPLEVEL2(OP1, OP2, INV1, INV2) \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 13); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 32); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 45); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 64); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 77); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 96); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 109); \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 128);
#else
#define TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, n) \
  TESTTRIOPLEVEL4(OP1, OP2, INV1, INV2, n, 109);

#define TESTTRIOPLEVEL2(OP1, OP2, INV1, INV2) \
  TESTTRIOPLEVEL3(OP1, OP2, INV1, INV2, 109);
#endif // FASTTEST
