#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testXorAssignInvertLevel3(void)
  {
    libecc::bitset<n> tmp1 = get_x(OverLoadHook<n>());
    tmp1 ^= ~get_y(OverLoadHook<m>());
    libecc::bitset<n> res = get_x(OverLoadHook<n>());
    libecc::bitset<128> tmp2 = ~get_y(OverLoadHook<m>());
    res ^= tmp2;
    CPPUNIT_ASSERT( tmp1 == res );
    CPPUNIT_ASSERT( (tmp1.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
  void bitsetTest::testXorAssignInvertLevel2(void)
  {
#ifndef FASTTEST
    testXorAssignInvertLevel3<n, 13>();
    testXorAssignInvertLevel3<n, 32>();
    testXorAssignInvertLevel3<n, 45>();
    testXorAssignInvertLevel3<n, 64>();
    testXorAssignInvertLevel3<n, 77>();
    testXorAssignInvertLevel3<n, 96>();
#endif
    testXorAssignInvertLevel3<n, 109>();
#ifndef FASTTEST
    testXorAssignInvertLevel3<n, 128>();
#endif
  }

void bitsetTest::testXorAssignInvert(void)
{
#ifndef FASTTEST
  testXorAssignInvertLevel2<13>();
  testXorAssignInvertLevel2<32>();
  testXorAssignInvertLevel2<45>();
  testXorAssignInvertLevel2<64>();
  testXorAssignInvertLevel2<77>();
  testXorAssignInvertLevel2<96>();
#endif
  testXorAssignInvertLevel2<109>();
#ifndef FASTTEST
  testXorAssignInvertLevel2<128>();
#endif
}
