#include "sys.h"
#include "debug.h"
#include <libecc/bitset.h>
#include <cppunit/extensions/HelperMacros.h>
#include "bitsetTest.h"

size_t const bitsetTest::digit_size;
size_t const bitsetTest::digit_bits;

char const* const bitsetTest::b7v3_str		=                                                         "05";
char const* const bitsetTest::b7v3_bare		=                                                          "5";
char const* const bitsetTest::b7v3_fit		=                                                         "85";
char const* const bitsetTest::b7v3_excess	=                                                        "F85";

char const* const bitsetTest::b32v3_str		=                                                   "00000005";
char const* const bitsetTest::b32v3_bare	=                                                          "5";
char const* const bitsetTest::b32v3_excess1	=                                                 " F00000005";
char const* const bitsetTest::b32v3_excess2	=                                                 "F 00000005";
char const* const bitsetTest::b32v3_excess3	=                                                "F F00000005";
char const* const bitsetTest::b32v3_excess4	=                                     "FFFFFFFFFFFFF 00000005";

char const* const bitsetTest::b32v32_str	=                                                   "D23DAE05";
char const* const bitsetTest::b32v32_excess1	=                                                  "1D23DAE05";
char const* const bitsetTest::b32v32_excess2	=                                                 "1 D23DAE05";
char const* const bitsetTest::b32v32_excess3	=                                     "FFFFFFFFFFFFF D23DAE05";

char const* const bitsetTest::b39v32_str	=                                                "00 D23DAE05";
char const* const bitsetTest::b39v32_bare	=                                                   "D23DAE05";
char const* const bitsetTest::b39v32_fit	=                                                "80 D23DAE05";
char const* const bitsetTest::b39v32_excess1	=                                               "180 D23DAE05";
char const* const bitsetTest::b39v32_excess2	=                                 "FFFFFFFF FFFFF180 D23DAE05";

char const* const bitsetTest::b64v63_str	=                                          "423DAE05 F8A013C7";
char const* const bitsetTest::b64v63_excess1	=               "0000FFFF FFFFFFFF FFFFFFFF 423DAE05 F8A013C7";
char const* const bitsetTest::b64v63_excess2	=      "      0000FFFFFFFFFFFF  FFFFFFFF  423DAE  05F8A01 3C7";

char const* const bitsetTest::b64v64_str	=                                          "F8A013C7 423DAE05";
char const* const bitsetTest::b64v64_excess	=                                        "1 F8A013C7 423DAE05";

char const* const bitsetTest::b65v65_str	=                                        "1 F8A013C7 423DAE05";
char const* const bitsetTest::b65v65_fit	=                                        "3 F8A013C7 423DAE05";
char const* const bitsetTest::b65v65_excess	=                        "0000FFFF FFFFFFFF F8A013C7 423DAE05";

char const* const bitsetTest::b195v195_str	=    "5 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";
char const* const bitsetTest::b195v195_fit	=    "D FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";

char const* const bitsetTest::b205v195_str	= "0005 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";
char const* const bitsetTest::b205v195_bare	=    "5 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";
char const* const bitsetTest::b205v195_fit	= "2005 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";

char const* const bitsetTest::b205v205_str	= "19C5 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";
char const* const bitsetTest::b205v205_fit	= "39C5 FFFFAAAA 5555FFFF 00005555 FFFF0000 F8A013C7 423DAE05";

char const* const bitsetTest::b_str[] = {
    b7v3_str, b32v3_str, b32v32_str, b39v32_str, b64v64_str, b64v63_str, b65v65_str, b195v195_str, b205v195_str, b205v205_str };

// 0110010110011010 = 659A
// 0011001100111100 = 333C
// -----------------------------
// 0010000100011000 = 2118   AND
// 0111011110111110 =        OR
// 0101011010100110 =        XOR
// -----------------------------
// 1111010000001011 = F40B
char const* const bitsetTest::x_str = "659A659A659A659A659A659A659A659A659A659A";
char const* const bitsetTest::y_str = "333C333C333C333C333C333C333C333C333C333C";
char const* const bitsetTest::z_str = "F40BF40BF40BF40BF40BF40BF40BF40BF40BF40B";
char const* const bitsetTest::x_AND_y_13_str = "118";
char const* const bitsetTest::x_AND_y_32_str = "21182118";
char const* const bitsetTest::x_AND_y_45_str = "11821182118";
char const* const bitsetTest::x_AND_y_64_str = "2118211821182118";
char const* const bitsetTest::x_AND_y_77_str = "1182118211821182118";
char const* const bitsetTest::x_AND_y_96_str = "211821182118211821182118";
char const* const bitsetTest::x_AND_y_109_str = "118211821182118211821182118";
char const* const bitsetTest::x_AND_y_128_str = "21182118211821182118211821182118";

CPPUNIT_TEST_SUITE_REGISTRATION( bitsetTest );
