//
//! \file  libecc/debug.h
//! \brief Debugging declarations and defines.
//!
//! This header file defines debugging macros
//! and declares debug channels that are being
//! used when libecc was configured with
//! \link enable_debug --enable-debug \endlink.
//!
//! \sa http://libcwd.sourceforge.net/reference-manual/group__chapter__custom__debug__h.html
//
// This file is part of the libecc package.
// Copyright (C) 2002, by
// 
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef LIBECC_DEBUG_H
#define LIBECC_DEBUG_H

#include <libecc/config.h>

#ifndef CWDEBUG

#include <iostream>

#define AllocTag1(p)
#define AllocTag2(p, desc)
#define AllocTag_dynamic_description(p, x)
#define AllocTag(p, x)
#define Debug(x)
#define Dout(a, b)
#define DoutFatal(a, b) LibcwDoutFatal(::std, , a, b)
#define ForAllDebugChannels(STATEMENT)
#define ForAllDebugObjects(STATEMENT)
#define LibcwDebug(dc_namespace, x)
#define LibcwDout(a, b, c, d)
#define LibcwDoutFatal(a, b, c, d) do { ::std::cerr << d << ::std::endl; ::std::exit(254); } while(1)
#define NEW(x) new x
#define CWDEBUG_ALLOC 0
#define CWDEBUG_MAGIC 0
#define CWDEBUG_LOCATION 0
#define CWDEBUG_LIBBFD 0
#define CWDEBUG_DEBUG 0
#define CWDEBUG_DEBUGOUTPUT 0
#define CWDEBUG_DEBUGM 0
#define CWDEBUG_DEBUGT 0
#define CWDEBUG_MARKER 0

#else // CWDEBUG

#ifndef DEBUGCHANNELS
#define DEBUGCHANNELS ::libecc::debug::channels
#endif
#include <libcw/debug.h>

namespace libecc {
  namespace debug {
    namespace channels {
      namespace dc {
	using namespace ::libcw::debug::channels::dc;

	extern ::libcw::debug::channel_ct ecc;
	extern ::libcw::debug::channel_ct polynomial;
	extern ::libcw::debug::channel_ct bitsetfind1;
	extern ::libcw::debug::channel_ct bitsetshift;

      } // namespace dc
    } // namespace DEBUGCHANNELS
  }
}

#endif // CWDEBUG

// Define private debug output macros for use in header files of the library.
#ifdef CWDEBUG
#define LibEccDout(cntrl, data) LibcwDout(DEBUGCHANNELS, libcw::debug::libcw_do, cntrl, data)
#define LibEccDoutFatal(cntrl, data) LibcwDoutFatal(DEBUGCHANNELS, libcw::debug::libcw_do, cntrl, data)
#else
#define LibEccDout(cntrl, data)
#define LibEccDoutFatal(cntrl, data) LibcwDoutFatal(::std, , cntrl, data)
#endif

#endif // LIBECC_DEBUG_H
