Summary: A C++ library for Elliptic Curve Cryptography
Name: libecc
%define __prefix /usr
%define version 0.5.0
Version: %{version}
Release: 1
Group: Development/Libraries
Source: http://download.sourceforge.net/libecc/libecc-%{version}.tar.gz
Copyright: GPL
%ifos linux
Requires: gcc-c++ >= 2.95.1, binutils >= 2.9
%endif
Buildroot: %{_tmppath}/%{name}-root
BuildPrereq: make, m4, which >= 2.5, autoconf >= 2.13, automake >= 1.5, libtool >= 1.4.2
URL: http://libecc.sourceforge.net/

%description
Libecc is an Elliptic Curve Cryptography C++ library for fixed
size keys in order to achieve a maximum speed.  The goal of
this project is to become the first free Open Source library
providing the means to generate ones own safe elliptic curves
and to become a source for anyone who wants to learn about
elliptic curve cryptography.

%prep
%setup

%build
./configure --prefix=%{__prefix}
make

%install
rm -rf "$RPM_BUILD_ROOT"
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf "$RPM_BUILD_ROOT"

%post
PATH="$PATH:/sbin" ldconfig -n %{__prefix}/lib

%files
%defattr(-,root,root)
%doc documentation/README
%doc documentation/index.html
%doc documentation/reference-manual
%doc documentation/scripts
%doc documentation/styles
%doc documentation/images
%doc documentation/external
%doc documentation/www
%dir %{__prefix}/include
%{__prefix}/lib/*
%{__prefix}/include/*

%changelog
* Sat Jul 27 2002 Carlo Wood <libecc@alinoe.com>
- Put %doc documentation/index.html above (currently) non-existing
  documentation directories because otherwise it is not added!

* Thu Jul 25 2002 Carlo Wood <libecc@alinoe.com>
- Added documentation directory to rpm.

* Tue Jul 23 2002 Carlo Wood <libecc@alinoe.com>
- Initial version.

