#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testAndAssignInvertLevel3(void)
  {
    libecc::bitset<n> tmp1;
    tmp1 = get_x(OverLoadHook<n>());
    tmp1 &= ~get_y(OverLoadHook<m>());
    libecc::bitset<n> res = get_x(OverLoadHook<n>());
    libecc::bitset<128> tmp2 = ~get_y(OverLoadHook<m>());
    res &= tmp2;
    CPPUNIT_ASSERT( tmp1 == res );
    CPPUNIT_ASSERT( (tmp1.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
  void bitsetTest::testAndAssignInvertLevel2(void)
  {
#ifndef FASTTEST
    testAndAssignInvertLevel3<n, 13>();
    testAndAssignInvertLevel3<n, 32>();
    testAndAssignInvertLevel3<n, 45>();
    testAndAssignInvertLevel3<n, 64>();
    testAndAssignInvertLevel3<n, 77>();
    testAndAssignInvertLevel3<n, 96>();
#endif
    testAndAssignInvertLevel3<n, 109>();
#ifndef FASTTEST
    testAndAssignInvertLevel3<n, 128>();
#endif
  }

void bitsetTest::testAndAssignInvert(void)
{
#ifndef FASTTEST
  testAndAssignInvertLevel2<13>();
  testAndAssignInvertLevel2<32>();
  testAndAssignInvertLevel2<45>();
  testAndAssignInvertLevel2<64>();
  testAndAssignInvertLevel2<77>();
  testAndAssignInvertLevel2<96>();
#endif
  testAndAssignInvertLevel2<109>();
#ifndef FASTTEST
  testAndAssignInvertLevel2<128>();
#endif
}
