#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n>
  void bitsetTest::testAssignmentLevel2(void)
  {
    libecc::bitset<n> tmp;
#ifndef FASTTEST
    tmp = b7v3;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b7v3_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b32v3;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b32v3_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b32v32;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b32v32_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b39v32;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b39v32_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b64v64;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b64v64_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b64v63;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b64v63_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b65v65;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b65v65_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
    tmp = b195v195;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b195v195_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#ifndef FASTTEST
    tmp = b205v195;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b205v195_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    tmp = b205v205;
    CPPUNIT_ASSERT( tmp == libecc::bitset<n>(b205v205_str) );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
  }

void bitsetTest::testAssignment(void)
{
#ifndef FASTTEST
  testAssignmentLevel2<7>();
  testAssignmentLevel2<32>();
  testAssignmentLevel2<39>();
  testAssignmentLevel2<64>();
  testAssignmentLevel2<65>();
#endif
  testAssignmentLevel2<195>();
#ifndef FASTTEST
  testAssignmentLevel2<205>();
#endif
}
