#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n>
  void bitsetTest::testBitAllLevel2(void)
  {
    libecc::bitset<n> const zeros("0");
    libecc::bitset<n> const ones("FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF");
    libecc::bitset<n> tmp1 = zeros;
    tmp1.setall();
    CPPUNIT_ASSERT( tmp1 == ones );
    tmp1.reset();
    CPPUNIT_ASSERT( tmp1 == zeros );
  }

void bitsetTest::testBitAll(void)
{
#ifndef FASTTEST
  testBitOpsLevel2<13>();
  testBitOpsLevel2<32>();
  testBitOpsLevel2<45>();
  testBitOpsLevel2<64>();
  testBitOpsLevel2<77>();
  testBitOpsLevel2<96>();
#endif
  testBitOpsLevel2<109>();
#ifndef FASTTEST
  testBitOpsLevel2<128>();
#endif
}

