#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

void bitsetTest::testConsts(void)
{
  CPPUNIT_ASSERT( libecc::bitset<205>::number_of_bits == 205 );
  CPPUNIT_ASSERT( libecc::bitset_digit_bits == digit_bits );

  CPPUNIT_ASSERT( libecc::bitset<127>::digits == libecc::bitset<128>::digits );
  CPPUNIT_ASSERT( libecc::bitset<128>::digits == libecc::bitset<129>::digits - 1 );
  CPPUNIT_ASSERT( libecc::bitset<129>::digits == libecc::bitset<130>::digits );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 127>::digits == libecc::bitset<digit_bits + 128>::digits );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 128>::digits == libecc::bitset<digit_bits + 129>::digits - 1 );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 129>::digits == libecc::bitset<digit_bits + 130>::digits );
  CPPUNIT_ASSERT( libecc::bitset<130>::digits == libecc::bitset<digit_bits + 130>::digits - 1 );
  CPPUNIT_ASSERT( libecc::bitset<128>::digits * digit_bits == 128 );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 128>::digits * digit_bits == digit_bits + 128 );

  CPPUNIT_ASSERT( libecc::bitset<127>::valid_bits == (~static_cast<libecc::bitset_digit_t>(0) >> 1) );
  CPPUNIT_ASSERT( libecc::bitset<128>::valid_bits == ~static_cast<libecc::bitset_digit_t>(0) );
  CPPUNIT_ASSERT( libecc::bitset<129>::valid_bits == 1);
  CPPUNIT_ASSERT( libecc::bitset<130>::valid_bits == 3);
  CPPUNIT_ASSERT( libecc::bitset<131>::valid_bits == 7);
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 127>::valid_bits == (~static_cast<libecc::bitset_digit_t>(0) >> 1) );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 128>::valid_bits == ~static_cast<libecc::bitset_digit_t>(0) );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 129>::valid_bits == 1 );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 130>::valid_bits == 3 );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 131>::valid_bits == 7 );

  CPPUNIT_ASSERT( libecc::bitset<127>::has_excess_bits );
  CPPUNIT_ASSERT( libecc::bitset<128>::has_excess_bits == false );
  CPPUNIT_ASSERT( libecc::bitset<129>::has_excess_bits );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 127>::has_excess_bits );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 128>::has_excess_bits == false );
  CPPUNIT_ASSERT( libecc::bitset<digit_bits + 129>::has_excess_bits );
}
