#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

// b7v3                                                                                     0000101
// b32v3                                                           00000000000000000000000000000101
// b32v32                                                          11010010001111011010111000000101
// b39v32                                                   000000011010010001111011010111000000101
// b64v64                          1111100010100000000100111100011101000010001111011010111000000101
// b64v63                          0100001000111101101011100000010111111000101000000001001111000111
// b65v65                         11111100010100000000100111100011101000010001111011010111000000101
// b195v195             10111...0001111100010100000000100111100011101000010001111011010111000000101
// b205v195   000000000010111...0001111100010100000000100111100011101000010001111011010111000000101
// b205v205   110011100010111...0001111100010100000000100111100011101000010001111011010111000000101

void bitsetTest::testEquality(void)
{
#ifndef FASTTEST
  CPPUNIT_ASSERT( b7v3 == b7v3 );
  CPPUNIT_ASSERT( b7v3 == b32v3 );
  CPPUNIT_ASSERT( b32v3 == b7v3 );
  CPPUNIT_ASSERT( !(b7v3 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b7v3) );
  CPPUNIT_ASSERT( !(b7v3 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b7v3) );

  CPPUNIT_ASSERT( b32v3 == b32v3 );
  CPPUNIT_ASSERT( !(b32v3 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b32v3) );
  CPPUNIT_ASSERT( !(b32v3 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b32v3) );

  CPPUNIT_ASSERT( b32v32 == b32v32 );
  CPPUNIT_ASSERT( b32v32 == b39v32 );
  CPPUNIT_ASSERT( b39v32 == b32v32 );
  CPPUNIT_ASSERT( !(b32v32 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b32v32) );
  CPPUNIT_ASSERT( !(b32v32 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b32v32) );

  CPPUNIT_ASSERT( b39v32 == b39v32 );
  CPPUNIT_ASSERT( !(b39v32 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b39v32) );
  CPPUNIT_ASSERT( !(b39v32 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b39v32) );

  CPPUNIT_ASSERT( b64v64 == b64v64 );
  CPPUNIT_ASSERT( !(b64v64 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b64v64) );
  CPPUNIT_ASSERT( !(b64v64 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b64v64) );

  CPPUNIT_ASSERT( b64v63 == b64v63 );
  CPPUNIT_ASSERT( !(b64v63 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b64v63) );
  CPPUNIT_ASSERT( !(b64v63 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b64v63) );
#endif

  CPPUNIT_ASSERT( b65v65 == b65v65 );
  CPPUNIT_ASSERT( !(b65v65 == b195v195) );
  CPPUNIT_ASSERT( !(b195v195 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b205v195) );
  CPPUNIT_ASSERT( !(b205v195 == b65v65) );
  CPPUNIT_ASSERT( !(b65v65 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b65v65) );

#ifndef FASTTEST
  CPPUNIT_ASSERT( b195v195 == b195v195 );
  CPPUNIT_ASSERT( b195v195 == b205v195 );
  CPPUNIT_ASSERT( b205v195 == b195v195 );
  CPPUNIT_ASSERT( !(b195v195 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b195v195) );

  CPPUNIT_ASSERT( b205v195 == b205v195 );
  CPPUNIT_ASSERT( !(b205v195 == b205v205) );
  CPPUNIT_ASSERT( !(b205v205 == b205v195) );

  CPPUNIT_ASSERT( b205v205 == b205v205 );
#endif
}
