#ifdef TESTROTATE
#define SHIFTROTATE(result, input, shift, direction) input.template rotate<shift, direction>(result)
#else
#define SHIFTROTATE(result, input, shift, direction) input.template shift_op<shift, direction, libecc::assign>(result)
#endif

#define SRTEST(inc, tot) \
  ltmp3 = ltmp2; \
  SHIFTROTATE(ltmp2, ltmp3, inc, libecc::left); \
  SHIFTROTATE(ltmp1, seed, tot, libecc::left); \
  CPPUNIT_ASSERT( ltmp1 == ltmp2 ); \
  rtmp3 = rtmp2; \
  SHIFTROTATE(rtmp2, rtmp3, inc, libecc::right); \
  SHIFTROTATE(rtmp1, seed, tot, libecc::right); \
  CPPUNIT_ASSERT( rtmp1 == rtmp2 );

#ifdef TESTROTATE
#define POSTTEST \
  CPPUNIT_ASSERT( ltmp1 == seed ); \
  CPPUNIT_ASSERT( rtmp1 == seed )
#define ROTATE true
#else
#define POSTTEST \
  CPPUNIT_ASSERT( !ltmp1.any() ); \
  CPPUNIT_ASSERT( !rtmp1.any() )
#define ROTATE false
#endif

#define TESTSTART(n) \
  if (1) \
  { \
    libecc::bitset<n> const seed = get_seed<n, ROTATE>(0); \
    libecc::bitset<n> const seed1left = get_seed<n, ROTATE>(1); \
    libecc::bitset<n> const seed1right = get_seed<n, ROTATE>(-1); \
    libecc::bitset<n> rtmp1, rtmp2, rtmp3, ltmp1, ltmp2, ltmp3; \
    SHIFTROTATE(ltmp1, seed, 1, libecc::left); \
    CPPUNIT_ASSERT( ltmp1 == seed1left ); \
    SHIFTROTATE(rtmp1, seed, 1, libecc::right); \
    CPPUNIT_ASSERT( rtmp1 == seed1right ); \
    SHIFTROTATE(ltmp2, ltmp1, 1, libecc::left); \
    SHIFTROTATE(ltmp1, seed, 2, libecc::left); \
    CPPUNIT_ASSERT( ltmp1 == ltmp2 ); \
    SHIFTROTATE(rtmp2, rtmp1, 1, libecc::right); \
    SHIFTROTATE(rtmp1, seed, 2, libecc::right); \
    CPPUNIT_ASSERT( rtmp1 == rtmp2 );

#define TESTEND \
    POSTTEST; \
  }

// 128 random bit pattern.
int const bits[128] = {
 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0,
 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0,
 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1
};

template<unsigned int n, bool rotate>
  libecc::bitset<n> get_seed(int shift)
  {
    libecc::bitset<n> res;
    res.reset();
    for (unsigned int i = 0; i < n; ++i)
    {
      if (rotate)
      {
	if (bits[(i + n - shift) % n])
	  res.set(i);
      }
      else
      {
	if ((int)i + shift < 0 || i + shift >= n)
	  continue;
	if (bits[i])
	  res.set(i + shift);
      }
    }
    return res;
  }
