#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testXorAssignLevel3(void)
  {
    libecc::bitset<n> tmp1 = get_x(OverLoadHook<n>());
    tmp1 ^= get_y(OverLoadHook<m>());
    libecc::bitset<n> res = get_x(OverLoadHook<n>());
    res |= get_y(OverLoadHook<m>());
    libecc::bitset<128> tmp2 = get_x(OverLoadHook<n>());
    tmp2 &= get_y(OverLoadHook<m>());
    tmp2 = ~tmp2;
    res &= tmp2;
    CPPUNIT_ASSERT( tmp1 == res );
    CPPUNIT_ASSERT( (tmp1.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
void bitsetTest::testXorAssignLevel2(void)
{
#ifndef FASTTEST
  testXorAssignLevel3<n, 13>();
  testXorAssignLevel3<n, 32>();
  testXorAssignLevel3<n, 45>();
  testXorAssignLevel3<n, 64>();
  testXorAssignLevel3<n, 77>();
  testXorAssignLevel3<n, 96>();
#endif
  testXorAssignLevel3<n, 109>();
#ifndef FASTTEST
  testXorAssignLevel3<n, 128>();
#endif
}

void bitsetTest::testXorAssign(void)
{
#ifndef FASTTEST
  testXorAssignLevel2<13>();
  testXorAssignLevel2<32>();
  testXorAssignLevel2<45>();
  testXorAssignLevel2<64>();
  testXorAssignLevel2<77>();
  testXorAssignLevel2<96>();
#endif
  testXorAssignLevel2<109>();
#ifndef FASTTEST
  testXorAssignLevel2<128>();
#endif
}
