#include "sys.h"
#include "debug.h"
#include <libecc/rng.h>
#include <iostream>
#include <fstream>

// Random number, generated by radioactive decay (http://www.fourmilab.ch/hotbits/).
// Use http://www.fourmilab.ch/cgi-bin/uncgi/Hotbits?nbytes=65&fmt=hex
// to get your own.  DON'T BE ANTI-SOCIAL, USE WITH MODERATION, HOTBITS
// ONLY PRODUCES 30 BYTES PER SECOND WHICH HAS TO BE DEVIDED WORLD WIDE!
char const* hotbits_str =
  "88F5E378EBA135F0910317D01D02005130C03FF55059BEEC025D7F0AC18A345C"
  "3426EF565521CB88861732E5563C54A8BFAF690FB9122CB5C5D37911D741490B"
  "D5";

int main(void)
{
  std::cout << "Generating 512,000,000 pseudo random bits.  Writing output to the file 'testRng.out'..." << std::endl;

  libecc::rng::pool_type pool(hotbits_str);
  libecc::rng rng(pool);
  libecc::bitset<512> out;
  std::ofstream f;
  f.open("testRng.out");
  for (int cnt = 0; cnt < 1000000; ++cnt)
  {
    rng.generate_512_bits();
    out = rng.get_512_bits();
    for (int d = 0; d < libecc::bitset<512>::digits; ++d)
    {
      libecc::bitset_digit_t digit = out.digit(d);
      f.write(reinterpret_cast<char*>(&digit), 4);
    }
  }
  f.close();
  return 0;
}

