! libevaluator - library of procedures for evaluating mathematical
! functions.
!
! Copyright (C) 2002 Aleksandar B. Samardzic
!
! This program is free software; you can redistribute it and/or modify
! it under the terms of the GNU General Public License as published by
! the Free Software Foundation; either version 2 of the License, or (at
! your option) any later version.
!
! This program is distributed in the hope that it will be useful, but
! WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
! General Public License for more details.
!
! You should have received a copy of the GNU General Public License
! along with this program; if not, write to the Free Software
! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
! USA

module evaluator_module
implicit none

! Module contains Fortran 90 interface for libevaluator library.  
! For description of functions constituting interface see library 
! documentation or evaluator.h file.  There exist two differences 
! only between C and Fortran 90 interface: 
! 1. Evaluator object is represented by integer in Fortran 90 
! interface, while void pointer type is used in C interface.  
! 2. Third argument of function evaluator_evaluate() is array of
! strings in C interface (where each string represents variable 
! name) while in Fortran 90 interface variable names should be 
! put in signle string with blanks used as separators beetwen 
! successive names.  
interface
   integer function evaluator_create (string)
     character(len=*), intent(in) :: string
   end function evaluator_create

   subroutine evaluator_destroy (evaluator)
     integer, intent(in) :: evaluator
   end subroutine evaluator_destroy
 
   double precision function evaluator_evaluate (evaluator, count, names, &
     values)
     integer, intent(in) :: evaluator
     integer, intent(in) :: count
     character(len=*), intent(in) :: names
     double precision, dimension(*), intent(in) :: values
   end function evaluator_evaluate

   subroutine evaluator_write (evaluator)
     integer, intent(in) :: evaluator
   end subroutine evaluator_write
   
   integer function evaluator_derivate (evaluator, name)
     integer, intent(in) :: evaluator
     character(len=*), intent(in) ::  name
   end function evaluator_derivate

   double precision function evaluator_evaluate_x (evaluator, x)
     integer, intent(in) :: evaluator
     double precision, intent(in) ::  x
   end function evaluator_evaluate_x

   double precision function evaluator_evaluate_x_y (evaluator, x, y)
     integer, intent(in) :: evaluator
     double precision, intent(in) ::  x, y
   end function evaluator_evaluate_x_y

   double precision function evaluator_evaluate_x_y_z (evaluator, x, y, z)
     integer, intent(in) :: evaluator
     double precision, intent(in) ::  x, y, z
   end function evaluator_evaluate_x_y_z

   integer function evaluator_derivate_x (evaluator)
     integer, intent(in) :: evaluator
   end function evaluator_derivate_x

   integer function evaluator_derivate_y (evaluator)
     integer, intent(in) :: evaluator
   end function evaluator_derivate_y

   integer function evaluator_derivate_z (evaluator)
     integer, intent(in) :: evaluator
   end function evaluator_derivate_z
end interface
end module evaluator_module
