/* Test hexdump
 *
 * cat utf8.html | ./t5hexdump.o
 */

#include <stdio.h>
#include <stdlib.h>
#include "mba/hexdump.h"
#include "mba/profile.h"

#define BSIZE 256

int
main()
{
	char buf[BSIZE];
	size_t n;
	unsigned int w;

	fprintf(stderr, "cat utf8.html | ./t5hexdump.o\n");

	w = 4;
	while ((n = fread(buf, 1, BSIZE, stdin)) > 0) {
		hexdump(stdout, buf, n, w);
		if (w < 8) {
			w *= 2;
		}
	}

	profile_report(stderr);

    return EXIT_SUCCESS;
}
