/* Test profile
 *
 * ./t7profile.o 
 * yoda 
 * is
 * dyslexic
 * ^D
 * dyslexic
 * is
 * yoda 
 */

#include <stdio.h>
#include "mba/stack.h"
#include "mba/profile.h"

int
main(int argc, char *argv[])
{
	char *line;
	struct stack *s;

	fprintf(stderr, "./t7profile.o type: yoda <enter> is <enter> dyslexic <enter> ^D\n");

	s = stack_new(30);
	while ((line = malloc(32)) != NULL && scanf("%s", line) != EOF) {
		stack_push(s, line);
	}
	while ((line = stack_pop(s)) != NULL) {
		printf("%s\n", line);
		free(line);
	}
	stack_del(s, free);

	profile_report(stdout);
	return 1;
}
