/* Test stack
 *
 * ./t8stack.o
 */

#include <stdio.h>
#include <stdlib.h>
#include "mba/msgno.h"
#include "mba/profile.h"
#include "mba/stack.h"

#define N 100000

#define P0 20000
#define P1 40000
#define P2 60000
#define P3 80000

#define R0 9
#define R1 1
#define R2 4
#define R3 2

int
main()
{
    char *str;
    int i, n = 0;
	int rate = R0;
    struct stack *s = stack_new(N);
	if (s == NULL) {
		MSG("Failed to allocate stack");
		return 1;
	}
    for (i = 0; i < N; i++) {
		switch (i) {
			case P1:
				rate = R1;
				break;
			case P2:
				rate = R2;
				break;
			case P3:
				rate = R3;
		}
		if (rand() % 10 < rate) {
	        str = malloc(8);
	        sprintf(str, "%07d", n++);
	        if (stack_push(s, str)) {
	 	      	printf("push  %s %d\n", str, stack_size(s));
			} else {
				printf("stack full");
				free(str);
			}
		} else {
			if (stack_is_empty(s)) {
				printf("stack empty\n");
			} else {
		        str = stack_pop(s);
				if (str) {
	    	    	printf("popped %s %d\n", str, stack_size(s));
			       	free(str);
				} else {
					printf("error popping from non-empty stack\n");
				}
			}
		}
    }

    stack_del(s, free);
	profile_report(stdout);
	profile_del();

    return 0;
}
