<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"
	encoding="ISO-8859-1"
	doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>

<xsl:template match="/">
	<html>
		<xsl:apply-templates select="module"/>
	</html>
</xsl:template>

<xsl:template match="module">
	<xsl:variable name="section-name" select="concat(translate(substring(@name,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'), substring(@name,2))"/>
	<head>
    <style type="text/css">
		pre { 
		    font-family: monospace;
		    border: 1px solid black;
		    white-space: pre; 
		    color: black;
		    background-color: #dfdfdf; 
		}
		table {
			border-top: 1px solid #000000;
			border-right: 1px solid #000000;
		}
		td, th {
			border-bottom: 1px solid #000000;
			border-left: 1px solid #000000;
		}
	</style>
	<title><xsl:value-of select="$section-name"/></title>
	</head>
	<body bgcolor="#f5f5f5">
	<h2><font color="#0000cd">
		<xsl:number level="multiple" count="module|group|meth" format="1.1.1"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="$section-name"/>
		<xsl:text> </xsl:text>
		<code>&lt;<xsl:value-of select="interface/include"/>&gt;</code>
	</font></h2>
	<xsl:apply-templates select="desc"/>
	<xsl:apply-templates select="interface/group"/>
	<hr noshade="noshade"/>
	<!-- a href="http://validator.w3.org/check/referer"><img border="0" src="http://www.w3.org/Icons/valid-html401" alt="Valid HTML 4.01!" height="31" width="88" align="right"/></a -->
	<font size="-1">
		Michael B. Allen &lt;mballen@erols.com&gt;<br/>
		Thu Mar 21 00:52:48 EST 2002
	</font>
	</body>
</xsl:template>

<xsl:template match="group">
	<h3><font color="#0000cd">
		<xsl:number level="multiple" count="module|group|meth" format="1.1.1"/>
		<xsl:text> </xsl:text><xsl:value-of select="title"/>
	</font></h3>
	<xsl:if test="desc">
		<p><xsl:apply-templates select="desc"/></p>
	</xsl:if>
	<xsl:apply-templates select="code|meth"/>
</xsl:template>

<xsl:template match="code">
	<p><font size="+1" color="#0000cd">
	<b><xsl:number level="multiple" count="module|group|meth" format="1.1.1"/>
		<xsl:text> </xsl:text><xsl:apply-templates select="title"/></b>
	</font><br/>
	<b>Synopsis</b>
	<pre><br/>  #include &lt;<xsl:value-of select="ancestor::interface/include"/>&gt;<xsl:value-of select="pre"/>
	</pre>
	<b>Description</b><br/>
		<xsl:apply-templates select="desc"/><br/>
	<xsl:if test="ret">
		<b>Returns</b><br/>
			<xsl:apply-templates select="ret"/><br/>
	</xsl:if>
	</p>
</xsl:template>

<xsl:template match="meth">
	<xsl:variable name="fn-name" select="concat(ancestor::module/@name, '_', @name)"/>
	<p><font size="+1" color="#0000cd">
	<b><xsl:number level="multiple" count="module|group|meth" format="1.1.1"/>
		The <code><xsl:value-of select="$fn-name"/></code> function</b>
	</font><br/>
	<b>Synopsis</b>
	<pre><br/>  #include &lt;<xsl:value-of select="ancestor::interface/include"/>&gt;<br/>
		<xsl:text>  </xsl:text><xsl:value-of select="pre"/><br/>
	</pre>
	<b>Description</b><br/>
		<xsl:apply-templates select="desc"/><br/>
	<xsl:if test="ret">
		<b>Returns</b><br/>
			<xsl:apply-templates select="ret"/><br/>
	</xsl:if>
	</p>
</xsl:template>

<xsl:template match="desc/br">
	<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="desc/p">
	<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="desc/pre">
	<pre><xsl:value-of select="."/>
	</pre>
</xsl:template>

<xsl:template match="a">
	<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="ident">
	<tt>
		<xsl:apply-templates/>
	</tt>
</xsl:template>

<xsl:template match="desc/def">
	<i>
		<xsl:apply-templates/>
	</i>
</xsl:template>

<xsl:template match="examplenum">
	<xsl:number level="any" count="example" format="1. "/>
</xsl:template>

<xsl:template match="tablenum">
	<xsl:number level="any" count="table" format="1. "/>
</xsl:template>

<!--
<xsl:template match="text()">
	<xsl:value-of select="normalize-space(.)"/>
</xsl:template>
-->

<xsl:template match="example">
	<p><b>Example <xsl:number level="any" count="example" format="1. "/><xsl:apply-templates select="title"/></b></p>
	<xsl:apply-templates select="desc"/>
	<xsl:copy-of select="pre"/>
</xsl:template>

<xsl:template match="table">
	<table cellpadding="2" cellspacing="0" align="right">
		<tr><td colspan="5"><b>Table <xsl:number level="any" count="table" format="1. "/>
				<xsl:apply-templates select="desc"/></b>
		</td></tr>
		<xsl:copy-of select="tr"/>
	</table>
</xsl:template>

<xsl:template match="tt">
	<tt>
		<xsl:apply-templates/>
	</tt>
</xsl:template>

</xsl:stylesheet>
