<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8"/>

<xsl:template match="module">
	<xsl:variable name="module-name" select="@name"/>
	<xsl:for-each select="meth">
		<xsl:call-template name="method">
			<xsl:with-param name="module-name"><xsl:value-of select="$module-name"/></xsl:with-param>
		</xsl:call-template>
			<xsl:text>
</xsl:text>
	</xsl:for-each>
</xsl:template>

<xsl:template name="method">
	<xsl:param name="module-name"/>
	<xsl:apply-templates select="ret"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="$module-name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>(</xsl:text>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="param">
	<xsl:value-of select="@type"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="ret">
	<xsl:value-of select="@type"/>
</xsl:template>

<xsl:template match="*|text()"/>

</xsl:stylesheet>
