#ifndef DOMNODE_H
#define DOMNODE_H

/* domnode - simple XML DOM-like interface
 */

#include <stdio.h>
#include "linkedlist.h"

struct domnode {
	const char *name;
	const char *value;
	struct linkedlist *children;
	struct linkedlist *attrs;
};

struct domnode *domnode_new(const char *name, const char *value);
void domnode_del(void *this);

int domnode_load(struct domnode *this, const char *filename);
int domnode_store(struct domnode *this, const char *filename);
size_t domnode_read(struct domnode *this, FILE *stream);
size_t domnode_write(struct domnode *this, FILE *stream);

struct domnode *domnode_search(struct domnode *this, const char *name);

int domnode_attrs_put(struct linkedlist *attrs, struct domnode *attr);
struct domnode *domnode_attrs_get(struct linkedlist *attrs, const char *name);
struct domnode *domnode_attrs_remove(struct linkedlist *attrs, const char *name);

#endif /* DOMNODE_H */

