#ifndef PROFILE_H
#define PROFILE_H

/* profile - a memory management profiler
 */

#ifdef PROFILE
  #define calloc(nmemb, size) profile_calloc((nmemb), (size), __FILE__, __LINE__)
  #define malloc(size) profile_malloc((size), __FILE__, __LINE__)
  #define free profile_free
  #define realloc(ptr, size) profile_realloc((ptr), (size), __FILE__, __LINE__)
  #define PROFILE_ADD(ptr, size) profile_add((ptr), (size), __FILE__, __LINE__)
#else
  #define PROFILE_ADD(ptr, size)
#endif

#include <stdio.h>

void profile_report(FILE *out);
void profile_del(void);

void *profile_calloc(size_t nmemb, size_t size, const char *file, unsigned int line);
void *profile_malloc(size_t size, const char *file, unsigned int line);
void profile_free(void *ptr);
void *profile_realloc(void *ptr, size_t size, const char *file, unsigned int line);
void profile_add(const void *ptr, size_t size, const char *file, unsigned int line);

#endif /* PROFILE_H */

