#ifndef STACK_H
#define STACK_H

/* stack - a dynamically resizing stack
 */ 

struct stack;
struct stack *stack_new(unsigned int max);
void stack_del(struct stack *s, void (*free_data_fn)(void *));

void stack_clear(struct stack *s, void (*free_data_fn)(void *));
int stack_push(struct stack *s, void *data);
void *stack_pop(struct stack *s);
int stack_is_empty(const struct stack *s);
unsigned int stack_size(const struct stack *s);
void stack_iterate(struct stack *s);
void *stack_next(struct stack *s);
void *stack_peek(struct stack *s);

#endif /* STACK_H */

