/* Test domnode module
 *
 * ./t2domnode.o sample1.xml
 */

#include <stdlib.h>
#include <stdio.h>
#include <locale.h>
#include <errno.h>
#include "mba/msgno.h"
#include "mba/profile.h"
#include "mba/domnode.h"

const char *space = "                         ";

void
outline(struct domnode *node, size_t indent)
{
	struct domnode *n;

	printf("%s", space + (25 - indent));
	if (node->children == NULL) {
		printf("%s: %s\n", node->name, node->value);
		return;
	}
	printf("%s:", node->name);
	if (linkedlist_is_empty(node->attrs) == 0) {
		linkedlist_iterate(node->attrs);
		n = linkedlist_next(node->attrs);
		printf(" %s=%s", n->name, n->value);
		while ((n = linkedlist_next(node->attrs))) {
			printf(",%s=%s", n->name, n->value);
		}
	}
	printf("\n");
	linkedlist_iterate(node->children);
	while ((n = linkedlist_next(node->children))) {
		outline(n, indent + 2);
	}
}

int
run(int argc, char *argv[])
{
	struct domnode *cfg;

	cfg = domnode_new(NULL, NULL);
	if (domnode_load(cfg, argv[1]) == 0) {
		AMSG("Failed to load XML file: %s", argv[1]);
		return 0;
	}
	outline(cfg, 0);
	fflush(stdout);
	domnode_del(cfg);

	return 1;
}

int
main(int argc, char *argv[])
{
	if (!setlocale(LC_CTYPE, "")) {
		MSG("setlocale failed");
		return EXIT_FAILURE;
	}

	errno = 0;

	if (run(argc, argv) == 0) {
		MSG("Test run failed\n\nIf you have compiled with the encdec library try:\nxterm -u8 -fn '-*-fixed-*-*-*-*-12-*-*-*-*-*-iso10646-1'\nLANG=en_US.utf8 ./t2domnode.o sample1.xml");
		return EXIT_FAILURE;
	}

	MNO(0);

	profile_report(stderr);

	return EXIT_SUCCESS;
}
