/* Test hashmap
 *
 * ./t3hashmap.o
 */

#include <stdio.h>
#include <stdlib.h>
#include "mba/profile.h"
#include "mba/hashmap.h"

#define N 10000

#define P0 2000
#define P1 4000
#define P2 6000
#define P3 8000

#define R0 9
#define R1 1
#define R2 7
#define R3 1

int
main()
{
    char *str;
    int i, n = 0;
	int rate = R0;
    struct hashmap *h = hashmap_new(HASHMAP_MEDIUM, hash_string, NULL, free);
	if (h == NULL) {
		printf("error allocating hashmap\n");
		return 1;
	}
	for (i = 0; i < N; i++) {
		switch (i) {
			case P1:
				rate = R1;
				break;
			case P2:
				rate = R2;
				break;
			case P3:
				rate = R3;
		}
		if (rand() % 10 < rate) {
	        str = malloc(8);
	        sprintf(str, "%07d", n++);
	        if (hashmap_put(h, str, str)) {
	 	      	printf("put  %s %d\n", str, hashmap_size(h));
			} else {
				printf("error putting element into hashmap\n");
				free(str);
			}
		} else {
			if (hashmap_is_empty(h)) {
				printf("hashmap empty\n");
			} else {
				hashmap_iterate(h);
		        str = hashmap_next(h);
				if (str) {
					str = hashmap_get(h, str);
	    	    	printf("get %s %d\n", str, hashmap_size(h));
					str = hashmap_remove(h, str);
					if (str) {
						printf("remove %s %d\n", str, hashmap_size(h));
						free(str);
					} else {
						printf("failed to remove from hashmap %s\n", str);
					}
				} else {
					printf("nothing left to iterate over\n");
				}
			}
		}
    }

    hashmap_del(h);
	profile_report(stderr);

    return 0;
}
