/* Test hashmap
 *
 * cat big.txt | ./t4hashmap.o
 */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include "mba/msgno.h"
#include "mba/hashmap.h"

/* Cannot profile hashmap because the profiler uses it!
 */

char *
get_word() {
	static char buf[64];
	int idx;

	for (idx = 0; (buf[idx] = fgetc(stdin)) != EOF; idx++) {
		if (idx == 63 || isspace(buf[idx])) {
			if (idx) {
				buf[idx] = '\0';
				return strdup(buf);
			}
			idx = 0;
		}
	}

	return NULL;
}

int
main()
{
    char *str;
    struct hashmap *h;
	unsigned int last_size;

	fprintf(stderr, "cat big.txt | ./t4hashmap.o\n");

	if ((h = hashmap_new(HASHMAP_MEDIUM, hash_string, NULL, free)) == NULL) {
		MSG("hashmap_new failed");
		return EXIT_FAILURE;
	}
	last_size = 0;
	while ((str = get_word()) != NULL) {
		if (hashmap_put(h, str, str) == 0) {
			MSG("hashmap_put failed");
			return EXIT_FAILURE;
		}
	}

    hashmap_del(h);

	MSG("hashmap_size=%u", hashmap_size(h));

    return EXIT_SUCCESS;
}
