/* Test linkedlist
 *
 * ./t6linkedlist.o
 */

#include <stdio.h>
#include <stdlib.h>
#include "mba/linkedlist.h"
#include "mba/profile.h"

#define N 50000

#define P0 10000
#define P1 20000
#define P2 30000
#define P3 40000

#define R0 9
#define R1 1
#define R2 5
#define R3 1

int
main()
{
    char *str;
    int i, j, n = 0;
	int rate = R0;
    struct linkedlist *l = linkedlist_new(N);

	if (l == NULL) {
		printf("error allocating linkedlist\n");
		return EXIT_FAILURE;
	}
    for (i = 0; i < N; i++) {
		switch (i) {
			case P1:
				rate = R1;
				break;
			case P2:
				rate = R2;
				break;
			case P3:
				rate = R3;
		}
		if (rand() % 10 < rate) {
			int idx = 0;
	        str = malloc(8);
	        sprintf(str, "%07d", n++);
			if (rand() % 5) {
				idx = linkedlist_size(l);
				if (idx) {
					idx = rand() % idx;
				}
			}
	        if (linkedlist_add(l, str)) {
	 	      	printf("  add %s size now %d\n", str, linkedlist_size(l));
			} else {
				printf("error adding to list\n");
				free(str);
			}
		} else {
			if (linkedlist_is_empty(l)) {
				printf("list empty\n");
			} else {
				j = rand() % linkedlist_size(l);
		        str = linkedlist_remove_last(l);
				if ((j % 10) == 0) {
					unsigned int count = 0;
					linkedlist_iterate(l);
					while (linkedlist_next(l)) {
						count++;
					}
					if (count != linkedlist_size(l)) {
						printf("failure: count=%u,linkedlist_size=%u\n",
												count, linkedlist_size(l));
						fflush(stdout);
						return EXIT_FAILURE;
					}
				}
				if (str) {
	    	    	printf("remove %s %d\n", str, linkedlist_size(l));
			       	free(str);
				} else {
					printf("error removing from non-empty list\n");
				}
			}
		}
    }
    linkedlist_del(l, free);

    return EXIT_SUCCESS;
}
