<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8"/>

<xsl:template match="/">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="module">
	<xsl:apply-templates select="copyright"/>
	<xsl:apply-templates select="manpage"/>
	<xsl:text>.SH NAME
</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text> \- </xsl:text>
	<xsl:value-of select="desc"/>
	<xsl:text>
</xsl:text>
	<xsl:apply-templates select="interface" mode="synopsis"/>
	<xsl:apply-templates select="interface" mode="description"/>
	<xsl:apply-templates select="interface" mode="returns"/>
</xsl:template>

<xsl:template match="copyright">
	<xsl:text>.\" </xsl:text>
	<xsl:value-of select="text()"/>
	<xsl:text>
.\"
</xsl:text>
</xsl:template>

<xsl:template match="manpage">
	<xsl:text>.TH </xsl:text>
	<xsl:value-of select="../@name"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@section"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@date"/>
	<xsl:text> "</xsl:text>
	<xsl:if test="@ll">
		<xsl:value-of select="@ll"/>
		<xsl:text>" "</xsl:text>
	</xsl:if>
	<xsl:value-of select="@title"/>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="interface" mode="synopsis">
	<xsl:text>.SH SYNOPSIS
.nf
</xsl:text>
	<xsl:apply-templates select="group" mode="synopsis"/>
	<xsl:text>.fi
</xsl:text>
</xsl:template>

<xsl:template match="interface" mode="description">
	<xsl:text>.SH DESCRIPTION
</xsl:text>
	<xsl:value-of select="../detail"/>
	<xsl:text>
.PP
</xsl:text>
	<xsl:apply-templates select="group/meth" mode="description"/>
</xsl:template>

<xsl:template match="interface" mode="returns">
	<xsl:text>.SH RETURNS
</xsl:text>
	<xsl:apply-templates select="group/meth[ret]" mode="returns"/>
</xsl:template>

<xsl:template match="group" mode="synopsis">
	<xsl:apply-templates select="code|meth" mode="synopsis"/>
	<xsl:text>.sp
</xsl:text>
</xsl:template>

<xsl:template match="code" mode="synopsis">
	<xsl:text>.B </xsl:text>
	<xsl:value-of select="text()"/>
	<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="meth" mode="synopsis">
	<xsl:text>.BI "</xsl:text>
	<xsl:apply-templates select="param"/>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="meth" mode="description">
	<xsl:text>.TP
.B </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>
</xsl:text>
	<xsl:apply-templates select="desc"/>
	<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="meth" mode="returns">
	<xsl:text>.TP
.B </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>
</xsl:text>
	<xsl:apply-templates select="ret"/>
	<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="text()">
	<xsl:value-of select="normalize-space(.)"/>
</xsl:template>

<xsl:template match="def">
	<xsl:text> </xsl:text>
	<xsl:apply-templates/>
	<xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="ident">
	<xsl:text>
.I </xsl:text>
	<xsl:apply-templates/>
	<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="meth/param">
	<xsl:choose>
		<xsl:when test="position()=1">
			<xsl:value-of select="substring-before(../proto,@name)"/>
			<xsl:text>" </xsl:text>
			<xsl:value-of select="@name"/>
			<xsl:text> "</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="substring-before(substring-after(../proto, preceding-sibling::param[position()=1]/@name), @name)"/>
			<xsl:text>" </xsl:text>
			<xsl:value-of select="@name"/>
			<xsl:text> "</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:if test="position()=last()">
		<xsl:value-of select="substring-after(../proto,@name)"/>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
