
#include "appua.h"
#include "example_rcfile.h"
#include <osip/sdp.h>

/* #include <unistd.h> */ 

extern osip_t *myconfig;

char *
getbodyfor200(sip_t *request)
{
    sdp_t *remote_sdp;
    sdp_t *local_sdp;
    int i;
    char *local_body;
    local_body = NULL;
    if (MSG_IS_INVITE(request))
      {
	body_t *body;
	body = (body_t *)list_get(request->bodies,0);

	local_sdp = (sdp_t *) smalloc(sizeof(sdp_t));
        remote_sdp = (sdp_t *) smalloc(sizeof(sdp_t));

	/* WE ASSUME IT IS A SDP BODY AND THAT    */
	/* IT IS THE ONLY ONE, OF COURSE, THIS IS */
	/* NOT TRUE */
	sdp_parse(remote_sdp,body->body);

	i = sdp_replyto(remote_sdp,local_sdp,getsipconf("username"),getsipconf("networktype"),getsipconf("addr_type"),getsipconf("localip"));
	local_body = sdp_2char(local_sdp);
	

	sdp_free(remote_sdp);
	sfree(remote_sdp);
	
	sdp_free(local_sdp);
	sfree(local_sdp);
	
      }
    
    return local_body;
}

/* fill default feilds for reply.                    */
/* OUTPUT: sip_t *dest | structure to store response.*/
/* INPUT : sip_t *request | previous request.        */
/* INPUT : int status | status for response.         */
/* INPUT : char *reason | reasonphrase for response. */
/* INPUT : char *body | body for response.           */
/* INPUT : int options | add a tag in to header.     */
/* return -1 on error */
/* TODO: add built-in support for record-route and route */
int
msg_makereply(int status,char *reason,sip_t *request,
	      sip_t *response,char *body,char *content_type
	      ,int options, err_t *err)
{
  int pos;
  int i;

  /* initialise sip_t structure */
  /* yet done... */

  response->strtline = (startline_t *)smalloc(sizeof(startline_t));
  response->strtline->sipversion = (char *)smalloc(8*sizeof(char));
  sprintf(response->strtline->sipversion,"SIP/2.0");
  response->strtline->statuscode = (char *)smalloc(5*sizeof(char));
  sprintf(response->strtline->statuscode,"%i",status);
  response->strtline->reasonphrase = (char *)smalloc(strlen(reason)+1);
  sprintf(response->strtline->reasonphrase,"%s",reason);

  response->strtline->rquri     = NULL;
  response->strtline->sipmethod = NULL;

  /* should add a tag in to feild (for useragent only) */
  /* add a boolean to reqest for it */
  {
    char *tmp;
    i = to_2char(request->to, &tmp, err);
    if (i==-1) return -1;
    i = msg_setto(response, tmp, err);
    sfree(tmp);
    if (i==-1) return -1;
    /*
      if (options==ADD_TAG)
      {
      response->to->tag = (char *)smalloc(12);
      sstrncpy(response->to->tag,"tag=faketag",11);
      }
    */
  }
  {
    char *tmp;
    i = from_2char(request->from, &tmp, err);
    if (i==-1) return -1;
    i = msg_setfrom(response, tmp, err);
    sfree(tmp);
    if (i==-1) return -1;
  }

  /* via headers */
  {
    char *tmp;
    pos = 0;
    while (!list_eol(request->vias,pos))
      {
	via_t *via;
	via = (via_t *)list_get(request->vias,pos);
	i = via_2char(via, &tmp, err);
	if (i==-1) return -1;
	i = msg_setvia(response, tmp, err);
	sfree(tmp);
	if (i==-1) return -1;
	pos++;
      }
  }

  {
    char *tmp;
    i = call_id_2char(request->call_id, &tmp, err);
    if (i==-1) return -1;
    i = msg_setcall_id(response, tmp, err);
    sfree(tmp);
    if (i==-1) return -1;
  }
  {
    char *tmp;
    i = cseq_2char(request->cseq, &tmp, err);
    if (i==-1) return -1;
    i = msg_setcseq(response, tmp, err);
    sfree(tmp);
    if (i==-1) return -1;
  }

   /* add personnal contact information (to be used for next request */
   /* (only for useragent) */
   if (body!=NULL)
     {
       char *size;
       i = msg_setbody(response, body, err);
       if (i==-1) return -1;

       size = (char *) smalloc(6*sizeof(char));
       sprintf(size,"%i",strlen(body));
       i = msg_setcontent_length(response, size, err);
       sfree(size);
       if (i==-1) return -1;

       {
	 char *ct = sgetcopy("content-type");
	 i = msg_setheader(response, ct, content_type, err);
	 sfree(ct);
	 if (i==-1) return -1;
       }
     }
   else
     {
       char *cl = sgetcopy("0");
       i = msg_setcontent_length(response, "0", err);
       sfree(cl);
       if (i==-1) return -1;
     }

   return 1;
}

int
osip_ul_sendmsg(transaction_t *transaction,sip_t *msg)
{
    sipevent_t *sipevent;
    
    sipevent = evt_new_fromuser(msg);
    sipevent->transactionid =  transaction->transactionid;

    uaapp_annouceoutrequest(sipevent->sip,sipevent->transactionid);
    fifo_add(transaction->transactionff,sipevent);

#ifdef WITH_4THREADS
    transaction_handler(transaction);
#endif
    return 0;
}

void
respondto200forinvite(int tid, sip_t *response)
{
  sip_t *ack;
  err_t err;
  transaction_t *transaction;
  transaction = trn_findid(myconfig->transactions, tid);

  msg_init(&ack, &err);

  if (1==makeack(ack,response))
    {
      osip_ul_sendmsg(transaction,ack);
    }
  else
    {
    trace(TRACE_LEVEL1,NULL,"<userctrl.c> Error while creating ACK request\n");
    msg_free(ack);
    sfree(ack);
    }
}

void
respondtoinvite(int tid, int code )
{
  respondtorequest(tid,code);
}

void
respondtorequest(int tid, int code )
{
  err_t err;
  char *reason;
  char *apptype;
  sip_t *response;
  transaction_t *transaction;
  char *local_body;
  transaction = trn_findid(myconfig->transactions, tid);

  msg_init(&response, &err);
  reason = parser_getreason(code);
  
  if (code<200&&code!=183)
    local_body = NULL;
  else
    {
      if ( !MSG_IS_BYE(transaction->lastrequest)
	   && !MSG_IS_REGISTER(transaction->lastrequest)
	   && !MSG_IS_CANCEL(transaction->lastrequest) )
	{
	  local_body =  getbodyfor200(transaction->lastrequest);
	  if (local_body==NULL)
	    code = 415;
	  /* WE MUST ADD THE CORRESPONDING WARNING ERROR */
	  /* getWarningphrase(i); */
	}
      else
	{
	  local_body=NULL;
	}
    }
  
  if (local_body!=NULL) /* only sdp is allowed in the test app.... */
    apptype = sgetcopy("application/sdp");
  else
    apptype = NULL;

  if (1==msg_makereply(code,reason,
		       transaction->lastrequest,
		       response,
		       local_body,
		       apptype,0, &err)) 
    {
      msg_setcontact(response, getsipconf("contact"), &err);
      osip_ul_sendmsg(transaction,response);
    }
  else
    {
      if (local_body!=NULL)
	sfree(local_body);
      trace(TRACE_LEVEL1,NULL,"<example_agentlogic.c> Could not create response for current status\n");
      sfree(response);
      sfree(reason);
      if (apptype!=NULL)
	sfree(apptype);
      return ;
    }
  if (local_body!=NULL)
    sfree(local_body);
  sfree(reason);
  if (apptype!=NULL)
    sfree(apptype);
}


int
sip_invite(session_t **session)
{
  static int only_once = 0;
  err_t err;
  sip_t         *invite;
  transaction_t *transaction;
  char *tmp;

  msg_init (&invite, &err);


  {/* mandatory */
    to_2char((*session)->to, &tmp, &err);
    msg_setto(invite,tmp, &err);
    sfree(tmp);
  }

  /* this is used for subject and User-Agent header */
  if ((*session)->headers!=NULL)
    {
    int pos = 0;
    while (!list_eol((*session)->headers,pos))
      {
      header_t *header;
      header = (header_t *)list_get((*session)->headers,pos);
      msg_setheader(invite,header->hname,header->hvalue, &err);
      pos++;
      }
    }
  /* do something for proxy ?!*/

  makeinvite(invite);

  if (only_once==0) {
    /* this is not used and not free() by any layer during test! */
    (*session)->callid = (call_id_t *)smalloc(sizeof(call_id_t));
    (*session)->callid->number = sgetcopy(invite->call_id->number);
    (*session)->callid->host   = sgetcopy(invite->call_id->host);
    
    (*session)->cseq = (cseq_t *)smalloc(sizeof(cseq_t));
    (*session)->cseq->number = sgetcopy(invite->cseq->number);
    (*session)->cseq->method = sgetcopy(invite->cseq->method);

    only_once = 1;
  }
  
  transaction = (transaction_t *) smalloc(sizeof(transaction_t));
  trn_init(myconfig,
	   transaction,
	   invite->to,
	   invite->from,
	   invite->call_id,
	   invite->cseq,
	   &err);

  osip_ul_sendmsg(transaction,invite);  
  
  return transaction->transactionid;
}

int
sip_bye(session_t **session)
{
  err_t err;
  sip_t         *bye;
  transaction_t *transaction;

  msg_init (&bye, &err);

  makebye(bye,NULL,(*session)->to,NULL
	  ,(*session)->callid,(*session)->cseq);
  fprintf(stdout,"BYE DONE: \n");


  transaction = (transaction_t *) smalloc(sizeof(transaction_t));
  trn_init(myconfig,
	   transaction,
	   bye->to,
	   bye->from,
	   bye->call_id,
	   bye->cseq,
	   &err);

  osip_ul_sendmsg(transaction,bye);
  
  return transaction->transactionid;
}

void
sip_register(char *expires)
{
  err_t err;
  sip_t         *sregister;
  transaction_t *transaction;
  char *registrationnumber = NULL;
  static call_id_t *registrationcallid = NULL;
  static int regnumber = 1;
  if (registrationcallid==NULL)
    {
      registrationcallid = (call_id_t *) smalloc(sizeof(call_id_t));
      call_id_setnumber(registrationcallid,sgetcopy("1239874324324"));
      call_id_sethost(registrationcallid,sgetcopy(getsipconf("localip")));
    }
  regnumber++;
  registrationnumber = (char *)smalloc(7*sizeof(char));
  sprintf(registrationnumber,"%i",regnumber);
  
  msg_init (&sregister, &err);
  makeregister(sregister,registrationcallid,registrationnumber,expires);

  sfree(registrationnumber);

  transaction = (transaction_t *) smalloc(sizeof(transaction_t));
  trn_init(myconfig,
	   transaction,
	   sregister->to,
	   sregister->from,
	   sregister->call_id,
	   sregister->cseq,
	   &err);

  osip_ul_sendmsg(transaction,sregister);

  return ;
}
