/*
 FILE: message.c
 AUTHOR: AYMERIC MOIZARD
 features: declaration of the SIP message format
*/ 

#include <osip/smsg.h>
#include "example_rcfile.h"

int
makeack(sip_t *dest,sip_t *response)
{
  err_t err;
  char *tmp;

  from_2char(response->from, &tmp, &err);
  msg_setfrom(dest, tmp, &err);
  sfree(tmp);
  
  to_2char(response->to, &tmp, &err);
  msg_setto(dest, tmp, &err);
  sfree(tmp);


  /* create Request-URI like for invite */
  dest->strtline = (startline_t *) smalloc(sizeof(startline_t));
  dest->strtline->sipmethod = (char *)smalloc(14);
  sprintf(dest->strtline->sipmethod,"ACK");
  dest->strtline->sipversion = (char *) smalloc(8*sizeof(char));
  sprintf(dest->strtline->sipversion,"SIP/2.0");

  dest->strtline->statuscode   = NULL;
  dest->strtline->reasonphrase = NULL;

  url_init(&(dest->strtline->rquri), &err);


  url_2char(dest->to->url, &tmp, &err);
  url_parse(dest->strtline->rquri, tmp, &err);
  sfree(tmp);
  /* if some headers and params exist remove unwanted information if
     They do not appear on request URI */
  /* TODO...  */


    tmp = (char *)smalloc(60*sizeof(char));
    sprintf(tmp,"SIP/2.0/UDP %s:%s",getsipconf("localip"),getsipconf("localport"));
    msg_setvia(dest, tmp, &err);
    sfree(tmp);

    call_id_2char(response->call_id, &tmp, &err);
    msg_setcall_id(dest, tmp, &err);
    sfree(tmp);


  /* MODIFICATION IS REQUIRED, IT MUST BE "number ACK" */
  cseq_init(&(dest->cseq), &err);
  cseq_setnumber(dest->cseq,sgetcopy(response->cseq->number));
  cseq_setmethod(dest->cseq,sgetcopy("ACK"));
  
  msg_setcontact(dest, getsipconf("contact"), &err);

  msg_setcontent_length(dest, "0", &err);

  return 1;
}

