/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <osip/port.h>

#ifndef __VXWORKS_OS__
#include <sys/time.h>
#else
#include <selectLib.h>
#include <time.h>
#endif

static FILE *logfile = NULL;
static int tracing_table[END_TRACE_LEVEL];

/* a,b, and x are used to generate random callid */
/* with a long period. */
static unsigned int a = 0;
static unsigned int b = 0;
static unsigned int x = 0;

void
init_random_number()
{
  a  = 4*(1+(int) (20000000.0*rand()/(RAND_MAX+1.0)))+1;
  b  = 2*(1+(int) (30324000.0*rand()/(RAND_MAX+1.0)))+1;
  x = (1+(int)   (23445234.0*rand()/(RAND_MAX+1.0)));
}

unsigned int
new_random_number()
{
  /* x(n) = a*x(n-1) + b */
  x = a*x + b;
  return x; /* jack: bug fix 13/07/01 */
}

int
satoi(char *number)
{
  return atoi(number);
}

char *
sstrncpy(char *dest,const char *src,int length)
{
  strncpy(dest,src,length);
  strncpy(dest+length,"\0",1);
  return dest;
}

void
susleep(int useconds)
{
  struct timeval delay;
  int sec;
  sec = (int)useconds/1000000;
  if (sec>0)
    {
    delay.tv_sec = sec;
    delay.tv_usec = 0;
    }
  else
    {
    delay.tv_sec = 0;
    delay.tv_usec =useconds;
    }
  select(0,0,0,0,&delay);
  
}


char *
sgetcopy(char *ch)
{
  char *copy;
  copy = (char *)smalloc(strlen(ch)+1);
  sstrncpy(copy,ch,strlen(ch));
  return copy;
}

/* corrected in 0.5.3... thanks to Steven donegan! */
int stolowercase(char *word) {
  int i = 0;
  int len = strlen (word);
  for (i=0 ; i<=len-1 ; i++) {
  if ('A' <= word[i] && word[i] <= 'Z') {
    word[i] = word[i]+32;
  }
  else {word[i] = word[i];}
  }
  return 1 ;
}

/* remove SPACE before and after the content */
int sclrspace(char *word) {
  char *pbeg;
  char *pend;
  int len = strlen(word);
  pbeg = word;
  while (0==strncmp( pbeg, (const char *) SP, 1)
	 ||0==strncmp( pbeg, (const char *) "\r", 1)
	 ||0==strncmp( pbeg, (const char *) "\n", 1)
	 ||0==strncmp( pbeg, (const char *) "\t", 1))
    pbeg++;
  pend = word + len -1;
  while (0==strncmp((const char *) pend, (const char *) SP, 1)
	 ||0==strncmp( pend, (const char *) "\r", 1)
	 ||0==strncmp( pend, (const char *) "\n", 1)
	 ||0==strncmp( pend, (const char *) "\t", 1)) 
      pend--;

  memmove(word,pbeg,pend-pbeg+1);
  /* DO NOT USE SSTRNCPY (it adds \0\0 at the end)     */
  /* and if there are no SPACE to remove, it may write */
  /* after the allocated space */
  strncpy(word+(pend-pbeg)+1,"\0",1);
  return 1; /* TRUE   */
}

/* in quoted-string, many characters can be escaped...   */
/* quote_find returns the next quote that is not escaped */
char *
quote_find(char *qstring)
{
  char *quote;
  quote = strchr(qstring,'"');
  if (quote==qstring) /* the first char matches and is not escaped...*/
    return quote;

  if (quote==NULL)
    return NULL; /* no quote at all... */

  /* this is now the nasty cases where '"' is escaped
     '" jonathan ros \\\""'
     |                  |
     '" jonathan ros \\"'
     |                |
     '" jonathan ros \""'
     |                |
     we must count the number of preceeding '\' */
  {
      int i = 1;
      while (1)
	{
	  if (0==strncmp(quote-i,"\\",1))
	    i++;
	  else
	    {
	      if (i%2==1) /* the '"' was not escaped */
		return quote;

	      /* else continue with the next '"'*/
	      quote = strchr(quote+1,'"');
	      if (quote==NULL) return NULL;
	      i = 1;
	    }
	  if (quote-i==qstring+1)
	    /* example: "\"john"  */
	    /* example: "\\"jack" */
	    {
	      if (i%2==0) /* the '"' was not escaped */
		return quote;
	      else
		{/* else continue with the next '"'*/
		  quote = strchr(quote+1,'"');
		  if (quote==NULL) return NULL;
		  i = 1;
		}
		
	    }
	}
      return NULL;
  }
}

/*
int sclrlws(char *word) {
  int i = 0;
  int j = 0;
  int len = strlen (word);
  char* r = (char*) smalloc (len+2);
  for (i=0 ; i<=len-1 ; i++) {
    if ((' '!=word[i])&&('\n'!=word[i])&&('\r'!=word[i])&&('\t'!=word[i]))
      {
	r[j] = word[i];
	j++;
      }
  }
  
  sstrncpy(word,r,j);
  sfree(r);
  return 1 ;
}
*/
#ifdef ENABLE_TRACE
/********************************************************/
/* only MACROS from osip/trace.h must be used by others */
/* TRACE_INITIALIZE(level,file))                        */
/* TRACE_ENABLE_LEVEL(level)                            */
/* TRACE_DISABLE_LEVEL(level)                           */
/* IS_TRACE_LEVEL_ACTIVATE(level)                       */
/********************************************************/

/* initialize log */
/* all lower levels of level are logged in file. */
void trace_initialize ( trace_level_t level , FILE *file )
{
  int i = 0;
  /* enable trace in log file by default */
  if (file!=NULL)
    logfile = file;
  else
    logfile = stdout;

  /* enable all lower levels */
  while (i<END_TRACE_LEVEL)
    {
      if (i<level)
	tracing_table[i]=LOG_TRUE;
      else
	tracing_table[i]=LOG_FALSE;
      i++;
    }
}

/* enable a special debugging level! */
void trace_enable_level ( trace_level_t level )
{
  tracing_table[level]=LOG_TRUE;
}

/* disable a special debugging level! */
void trace_disable_level (trace_level_t level)
{
  tracing_table[level]=LOG_FALSE;
}

/* not so usefull? */
int is_trace_level_activate ( trace_level_t level )
{
  return tracing_table[level];
}
#endif

int
#if defined(HAVE_STDARG_H) || defined(__VXWORKS_OS__)
trace(trace_level_t level,FILE *f,char *chfr, ...)
#else
trace(level,f,chfr,va_list)
     int level;
     FILE *f;
     char *chfr
#endif
{
  va_list ap;
#ifdef ENABLE_TRACE
  time_t ti;
  char *fmt;

  if (logfile==NULL)
    { /* user did not initialize logger.. */
      return 1;
    }
  if (f==NULL)
    f = logfile;
  if (tracing_table[level]==LOG_FALSE)
    return 1;

  fmt = (char *)smalloc(strlen(chfr)+18);
  ti = time(NULL);
  sprintf(fmt,"L%i -%li- %s",level,(long int)ti,chfr);
  VA_START(ap, chfr);

#ifdef __VXWORKS_OS__
  /* vxworks can't have a local file */
  f = stdout;
#endif
  vfprintf(f, fmt,ap);

  fflush(f);

  sfree(fmt);
#endif
  va_end(ap);
  return 1;
}



