/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include <stdlib.h>
#include <stdio.h>

#include <osip/port.h>

smutex_t *
smutex_init()
{
#ifndef __VXWORKS_OS__
  smutex_t *mut = (smutex_t *)smalloc(sizeof(smutex_t));
  pthread_mutex_init(mut, NULL);
  return mut;
#endif
#ifdef __VXWORKS_OS__
  return semMCreate(0);
#endif
}

void
smutex_destroy(smutex_t *mut)
{
#ifndef __VXWORKS_OS__
  pthread_mutex_destroy(mut);
#endif
#ifdef __VXWORKS_OS__
  semDelete(mut);
#endif
}

int
smutex_lock(smutex_t *mut)
{
#ifndef __VXWORKS_OS__
  int i;
  i = pthread_mutex_lock(mut);
  if (i!=0)
    {
      fprintf(stdout, "ERROR while locking !!%i",i);
      if (i==EINVAL)
	fprintf(stdout, "ERROR while locking EINVAL!!");
      if (i==EDEADLK)
	fprintf(stdout, "ERROR while locking EDEADLK!!");
      if (i==EBUSY)
	fprintf(stdout, "ERROR while locking EBUSY!!");
      if (i==EINVAL)
	fprintf(stdout, "ERROR while locking EINVAL!!");
      return i;
    }
  return 0;
#endif
#ifdef __VXWORKS_OS__
  return semTake(mut,WAIT_FOREVER);
#endif
}

int
smutex_unlock(smutex_t *mut)
{
#ifndef __VXWORKS_OS__
  return pthread_mutex_unlock(mut);
#endif
#ifdef __VXWORKS_OS__
  return semGive(mut);
#endif
}

/* Counting Semaphore is initialized to value          */
ssem_t *
ssem_init(unsigned int value)
{
#ifndef __VXWORKS_OS__
  ssem_t *sem = (ssem_t *)smalloc(sizeof(ssem_t));
  if (sem_init(sem, 0, value)==0)
    return sem;
  sfree(sem);
#else
  return semCCreate(SEM_Q_FIFO,value);
#endif
  return NULL;
}

int
ssem_destroy(ssem_t *sem)
{
#ifndef __VXWORKS_OS__
  return sem_destroy(sem);
#else
  int i;
  i = semDelete(sem);
  return 0;
#endif
}

int
ssem_post(ssem_t *sem)
{
#ifndef __VXWORKS_OS__
  return sem_post(sem);
#else
  return semGive(sem);
#endif
}

int
ssem_wait(ssem_t *sem)
{ 
#ifndef __VXWORKS_OS__
  return sem_wait(sem);
#else
  return semTake(sem,WAIT_FOREVER);
#endif
}

int
ssem_trywait(ssem_t *sem)
{ 
#ifndef __VXWORKS_OS__
  return sem_trywait(sem);
#else
  return semTake(sem,NO_WAIT);
#endif
}
