/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _SIPAPI_H_
#define _SIPAPI_H_

#include <netdb.h>

#include <osip/port.h>
#include <osip/trlayer.h>
#include <osip/types.h>
#include <osip/smsg.h>


/* API FOR CALL CONTROL */

/* start the stack with this design:                     */
/*    two threads for timers to enable retransamissions. */
/*    one thread listening on a udp port.                */
/*    one thread per transaction.                        */
/* INPUT :  osip_t *config | config of stack.                */
int sip_start_design1(int port,osip_t *config);

/* temporary patch targeted to linphone before improvements */
#ifdef LINPHONE
int sip_stop_design1(osip_t *config);
#endif

int trn_global_init();

/* initiate a new transaction.                               */
/* INPUT :  osip_t *config | config of stack.                */
/* OUTPUT:  transaction_t *dest | structure to save results. */
/* INPUT :  to_t *to | to for transaction.                   */
/* INPUT :  from_t *from | from for transaction.             */
/* INPUT :  call_id_t *callid | callid for transactio.        */
/* INPUT :  cseq_t *cseq | cseq for transactio.              */
/* returns null on error. */
int            trn_init(osip_t *config,
			transaction_t *dest,
			to_t *to,
			from_t *from,
			call_id_t *callid,
			cseq_t *cseq,
			err_t *err);
/* finds transaction corresponding to event.               */
/* YOU SHOULD NOT USE THIS METHOD, IT IS ALWAYS CALLED BY*/
/* THE STACK ITSELF.                                     */
/* INPUT :  sipevent_t *se | event must be filled.         */
/* returns null on error. */
transaction_t *trn_findfromuser(list_t *transactions, sipevent_t *se);
/* finds transaction corresponding to event.               */
/* INPUT :  osip_t *config | config of stack.                */
/* INPUT :  sipevent_t *se | event must be filled.         */
/* returns null on error. */
transaction_t *trn_findfromtransport(osip_t *config,
				     list_t *transactions, sipevent_t *se);
/* finds transaction corresponding to transactionid.   */
/* INPUT :  int transactionid | transactionid to find. */
/* returns null on error. */
transaction_t *trn_findid(list_t *transactions, int transactionid);
/* deallocates a transaction_t structure.             */
/* INPUT : transaction_t *transaction |  transaction. */
void           trn_free(transaction_t *transaction);
/* To be launched as a thread for handling a transaction.       */
/* YOU SHOULD NOT USE THIS METHOD, IT IS ALWAYS CALLED BY*/
/* THE STACK ITSELF.                                     */
/* This method loops on a fifo_t where events are sent.         */
/* INPUT : transaction_t *transaction |  transaction to handle. */
void          *trn_thread(transaction_t *transaction);
/* removes transaction corresponding to transactionid.   */
/* YOU SHOULD NOT USE THIS METHOD, IT IS ALWAYS CALLED BY*/
/* THE STACK ITSELF.                                     */
/* INPUT :  int transactionid | transactionid to remove. */
/* returns -1 on error. */
int            trn_removeid(list_t *transactions, int transactionid);

int            call_id_match(call_id_t *callid1,call_id_t *callid2);
int            callleg_match(to_t *to1,from_t *from1,to_t *to2,from_t *from2);
int            cseq_match(cseq_t *cseq1,cseq_t *cseq2);

#endif /* _SIPAPI_H_ */


