/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _SMSGTYPES_H_
#define _SMSGTYPES_H_

#include <osip/port.h>
#include <osip/urls.h>

/* for the body headers    */
#define MAX_BODYH_SIZE      500

/* for the maximum length  */
/* of messages up to 65000 */
#define MAX_MESSAGE_SIZE    4000

typedef struct _startline_t {
  /* msgevttype_t method; */
  char *sipmethod;
  char *sipversion;

  /* req */
  url_t *rquri;

  /* resp */
  char *statuscode;
  char *reasonphrase;

} startline_t ;

typedef struct _header_t {
  char *hname;
  char *hvalue;
} header_t;

typedef struct _cseq_t {
  char *method;
  char *number;
} cseq_t;

typedef struct _via_t {
  char *version;
  char *protocol;
  char *host;
  char *port;
  char *comment;
  list_t *via_params;
} via_t;

/*
  name-addr      = [ display-name ] "<" addr-spec ">"
  addr-spec      = SIP-URL | URI
  display-name   = *token | quoted-string

   Even if the "display-name" is empty, the "name-addr" form MUST be
   used if the "addr-spec" contains a comma, semicolon or question mark.
   Note that there may or may not be LWS between the display-name and
   the "<".

   From        =  ( "From" | "f" ) ":" ( name-addr | addr-spec )
                *( ";" from-param )
   from-param  =  tag-param | generic-param
   tag-param   =  "tag" "=" token

*/


typedef url_param_t generic_param_t;
/*
typedef url_param_t from_param_t;
*/
typedef struct _from_t {
  char *displayname;
  url_t *url;  /* could contain various urischeme_t ? only in the future */
  list_t *from_params;
} from_t;

/* typedef from_param_t to_param_t; */
typedef from_t to_t;

/* typedef from_param_t contact_param_t; */
typedef from_t contact_t;

/* typedef from_param_t record_route_param_t; */
typedef from_t record_route_t;

/* typedef from_param_t route_param_t; */
typedef from_t route_t;

typedef struct _call_id_t {
  char *number;
  char *host;
} call_id_t;


typedef struct _content_length_t {
  char *value;
} content_length_t;

typedef content_length_t content_encoding_t;
typedef content_length_t mime_version_t;

/* typedef url_param_t content_type_param_t; */

typedef struct _content_type_t {
  char   *type;
  char   *subtype;
  list_t *content_type_params;
} content_type_t;

typedef struct _body_t {
  char   *body;
  list_t *headers;
  content_type_t *content_type;
  /*  content_length_t   *content_length; */
} body_t;

typedef struct _sip_t {
  startline_t  *strtline;

  from_t    *from;
  to_t      *to;
  call_id_t *call_id;
  cseq_t    *cseq;
  list_t    *vias;
  list_t    *contacts;
  list_t    *record_routes;
  list_t    *routes;

  list_t    *headers;

  content_type_t   *content_type;
  content_length_t *contentlength;
  mime_version_t   *mime_version;
  list_t    *bodies;

} sip_t;


/* internal type for parser's config */
typedef struct _parser_config_t {
  char *hname;
  int  (*setheader)(sip_t*, char*, err_t*);
} parser_config_t;

#endif
