/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

#include <osip/port.h>

/********************************/
/* Methods from port_thread.c   */
/********************************/
/* launch a new thread.                               */
/* INPUT :  int stacksize | size of the stack (for VxWorks only).*/
/* INPUT :  void *(*func)(void *) | .*/
/* INPUT :  void *arg | arg is the parameter for func.*/
/* OUTPUT:  pthread_t *thread | thread ID.   */
/* returns SIP_NULL on error */
#ifdef __VXWORKS_OS__
int
#else
pthread_t *
#endif
sthread_create(int stacksize, pthread_t *thread, void *(*func)(void *), void *arg)
{
#ifndef __VXWORKS_OS__
  int i;
  if (thread==NULL)
    thread = (pthread_t *) smalloc(sizeof(pthread_t));
  
  i = pthread_create(thread,NULL
		     ,func
		     ,(void *)arg);
  if (i!=0)
    {
    fprintf(stdout,"<port_thread.c> Error while creating a new thread %i\n",i);
    return NULL;
    }

  return thread;

#else
  if (thread!=NULL)
    /* thread = (pthread_t *) smalloc(sizeof(pthread_t)); */
    printf("Never use sthread_create with thread!=NULL under vxworks\n");

  /* return ERROR (==-1?) if it fails */
  return taskSpawn(NULL,5,0,stacksize,(FUNCPTR)func,(int)arg,0,0,0,0,0,0,0,0,0);
#endif
}


#ifdef __VXWORKS_OS__
int
sthread_setpriority(int thread, int priority)
{
  taskPrioritySet(dest->threadid, 1);
  return 0;
}
#else
/* WARNING UNUSED METHOD */
int
sthread_setpriority(pthread_t *thread, int priority)
{
  return 0;
}
#endif

#ifdef __VXWORKS_OS__
int
sthread_join(int thread)
{
    return taskDelete(thread);
}
#else
int
sthread_join(pthread_t *thread)
{
    return pthread_join(*thread,NULL);
}
#endif


int
sthread_exit()
{
#ifndef __VXWORKS_OS__
  /* Seems to be needed to free ressources */
  pthread_exit(NULL);
#endif
}
