/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>
#include <time.h>

#ifndef __VXWORKS_OS__
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#else
/* should be ok */
#include "sockLib.h" 
#include "inetLib.h" 
#endif

#include <osip/trlayer.h>
#include <osip/port.h>
#include <osip/sip.h>
#include <osip/smsg.h>
#include <osip/fsm.h>
#include <osip/timers.h>

extern int control_fd;

int
sip_start_design1(int port ,osip_t *config)
{
  /* initialise the mutex that protects the access on */
  /* the list of transactions in osip_t structure.    */
  if (-1==trn_global_init())
    return -1; /* mutex is not initialised properly */

  /* load the fsm configuration */
  fsm_load_uac4inv();
  fsm_load_uas4inv();
  fsm_load_uac4req();
  fsm_load_uas4req();

  /* load the parser configuration */
  parser_configure();

  /* give a seed for all calls to rand() */
  srand(time(NULL));
  init_random_number();


  timersd_start(config);

  /* start a thread on the given port. */
  config->port = port;
  sipd_start(config);

  return 1; /* ok */
}

/* temporary patch targeted to linphone before improvements */
#ifdef LINPHONE
int sip_stop_design1(osip_t *config)
{
  char a=0;
  if (control_fd)
    write(control_fd,&a,1);  /* unblock the select() in udp_listen.c*/
  return(0);
}
#endif
