/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>

#ifndef __VXWORKS_OS__
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#ifdef __VXWORKS_OS__
#include "vxWorks.h" 
#include "sockLib.h" 
#include "inetLib.h" 
#endif

#include <osip/trlayer.h>
#include <osip/const.h>

void        *sipd_thread(osip_t *config);
sipevent_t  *evt_parse(char *buf);

int sipd_start(osip_t *config)
{
  trace(TRACE_LEVEL1,stdout,"<udp_listen.c> New UDP listener on port %i\n"
	  ,config->port);

  sthread_create(20000,NULL,(void *(*)(void *))sipd_thread
			 ,(void *)config);
  return 1; /* OK */
}

/* temporary patch targeted to linphone before improvements */
#ifdef LINPHONE
int output_sock=0;
fd_set osip_fdset;
int control_fd=0;
int max_fd=0;
#endif

void *
sipd_thread(osip_t *config)
{
  struct sockaddr_in  raddr;
  int	 sock;

#ifdef LINPHONE
  int err;
  int control_fds[2];
  int option=1;

  FD_ZERO(&osip_fdset);
#endif

  /* create a socket */
  sock = (int)socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
  
  raddr.sin_addr.s_addr = htons(INADDR_ANY);
  raddr.sin_port = htons((short)config->port);
  raddr.sin_family = AF_INET;
  
  if (bind(sock, (struct sockaddr *)&raddr, sizeof(raddr)) < 0) {
     trace(TRACE_LEVEL0,NULL,"<udp_listen.c> UDP listener bind failed %i!\n",config->port);

     exit(0);
  }
  

#ifdef LINPHONE
  output_sock = sock;
  err=setsockopt(sock, SOL_SOCKET , SO_REUSEADDR, (void*)&option, sizeof(option));
  if (err!=0) printf("Error in setsockopt()\n");
  max_fd=sock;
  /* create a set of file descritor to control the stack*/
  err=pipe(control_fds);
  if (err!=0)
    {
      perror("Error creating pipe");
      exit(1);
    }
  control_fd=control_fds[1]; /* the file descriptor where to write something to control the stack*/
  if (max_fd<control_fds[0]) max_fd=control_fds[0];
  
  FD_SET(sock,&osip_fdset );
  FD_SET(control_fds[0],&osip_fdset );
#endif

  while(1)
    { /* SIP_MESSAGE_MAX_LENGTH should be set to 66001
	 to improve interopperability */
    int i;
    char *buf = (char *)smalloc(SIP_MESSAGE_MAX_LENGTH*sizeof(char)+1);

#ifdef LINPHONE
    i=select( max_fd,&osip_fdset,NULL,NULL,NULL);
    /* if something to read on the control file descriptor, then exit thread*/
    if (FD_ISSET(control_fds[0],&osip_fdset))
      {
	close(sock);
	output_sock=0;
	trace(TRACE_LEVEL1,NULL,"<udp_listen.c> Exiting thread!\n");
	sfree(buf); /* added by AMD 18/08/2001 */
	return NULL;
      }
#endif

    i = recv(sock, buf, SIP_MESSAGE_MAX_LENGTH ,  0);
    if( i > 0 )
      {
	/* Message might not end with a "\0" but we know the number of */
	/* char received! */
	sipevent_t *sipevent;
	sstrncpy(buf+i,"\0",1);
	trace(TRACE_LEVEL4,stdout,"<udp_listen.c> RCV MESSAGE ON UDP!\n%s",buf);
	sipevent = evt_parse(buf);
	if (sipevent!=NULL)
	  evt_sendevent(config,sipevent);
      }
    else
      {
      trace(TRACE_LEVEL1,NULL,"<udp_listen.c> UDP listener failed while receiving data!\n");
      }
      sfree(buf);
    }
  return NULL;
}

