/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <osip/smsg.h>
#include <osip/port.h>
#include "msg.h"

static parser_config_t pconfig[NUMBER_OF_HEADERS];


/* This method must be called before using the parser */
int parser_init() {

  pconfig[0].hname=CALL_ID;
  pconfig[0].setheader=&msg_setcall_id;
  pconfig[1].hname=CONTACT;
  pconfig[1].setheader=&msg_setcontact;
  pconfig[2].hname=CONTENT_LENGTH;
  pconfig[2].setheader=&msg_setcontent_length;
  pconfig[3].hname=CONTENT_TYPE;
  pconfig[3].setheader=&msg_setcontent_type;
  pconfig[4].hname=CSEQ;
  pconfig[4].setheader=&msg_setcseq;
  pconfig[5].hname=FROM;
  pconfig[5].setheader=&msg_setfrom;
  pconfig[6].hname=MIME_VERSION;
  pconfig[6].setheader=&msg_setmime_version;
  pconfig[7].hname=RECORD_ROUTE;
  pconfig[7].setheader=&msg_setrecord_route;
  pconfig[8].hname=ROUTE;
  pconfig[8].setheader=&msg_setroute;
  pconfig[9].hname=TO;
  pconfig[9].setheader=&msg_setto;
  pconfig[10].hname=VIA;
  pconfig[10].setheader=&msg_setvia;

  return 0;
}

/* This method calls the method that is able to parse the header */
int
parser_callmethod(int i,sip_t *dest,char *hvalue)
{
  return pconfig[i].setheader(dest,hvalue);
}

/* search the header hname through pconfig[] tab. 
   A quicker algorithm should be used.
   It returns the index of the header in the parser_config_t tab.
*/
int
parser_isknownheader(char *hname) {
  size_t length ;
  int iinf   = 0;
  int isup   = NUMBER_OF_HEADERS;
  int i      = NUMBER_OF_HEADERS/2;
  
  length = strlen(hname);

    while (1)
    {
      if (i<0||i>NUMBER_OF_HEADERS-1)
	return -1;

      if ((length==strlen(pconfig[i].hname))
	  &&strncmp((const char *) hname,
		    (const char *) pconfig[i].hname,
		    length)==0)
	return i;
      
      if (iinf==isup)
	return -1; /* not found */
      if (iinf==isup-1)
	{
	  if ((i<NUMBER_OF_HEADERS-1)
	      &&(length==strlen(pconfig[i+1].hname))
	      &&strncmp((const char *) hname,
			(const char *) pconfig[i+1].hname,
			length)==0)
	      return i+1;
	  else
	    return -1;
	  if ((i>0)&&(length==strlen(pconfig[i-1].hname))
	      &&strncmp((const char *) hname,
			(const char *) pconfig[i-1].hname,
			length)==0)
	      return i-1;
	  else
	    return -1;
	}
      if (0<strncmp((const char *) hname,
		    (const char *) pconfig[i].hname , length)) {
	/* if this is true, search further */
	iinf = i;	      
	if (i == i + (isup-i)/2) i++;
	else  i = i + (isup-i)/2;
      } else {
	isup = i;
	if (i == i - (i-iinf)/2) i--;
	else i = i - (i-iinf)/2;
      }
    } /* end of (while (1)) */
  return -1;
} 

