/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <stdlib.h>

#include <osip/smsg.h>
#include <osip/port.h>


static int
startline_2charreq(startline_t *strtline, char **dest)
{
  char *tmp;
  char *rquri;
  int i;

  *dest = NULL;
  if ((strtline==NULL)||(strtline->rquri==NULL)
      ||(strtline->sipmethod==NULL)||(strtline->sipversion==NULL))
    return -1;

  i = url_2char(strtline->rquri, &rquri);
  if (i==-1)
    return -1;
  *dest = (char *)smalloc(strlen(strtline->sipmethod)
			  +strlen(rquri)
			  +strlen(strtline->sipversion)+3);
  tmp = *dest;
  sstrncpy(tmp,strtline->sipmethod,strlen(strtline->sipmethod));
  tmp = tmp + strlen(strtline->sipmethod);
  sstrncpy(tmp," ",1);
  tmp = tmp+1;
  sstrncpy(tmp,rquri,strlen(rquri));
  tmp = tmp + strlen(rquri);
  sstrncpy(tmp," ",1);
  tmp = tmp + 1;
  sstrncpy(tmp,strtline->sipversion,strlen(strtline->sipversion));

  sfree(rquri);
  return 0;
}

static int
startline_2charresp(startline_t *strtline, char **dest)
{
  char *tmp;
    
  *dest = NULL;
  if ((strtline==NULL)||(strtline->reasonphrase==NULL)
      ||(strtline->statuscode==NULL)||(strtline->sipversion==NULL))
    return -1;
  *dest = (char *)smalloc(strlen(strtline->sipversion)
		       +strlen(strtline->statuscode)
		       +strlen(strtline->reasonphrase)+4);
  tmp = *dest;

  sstrncpy(tmp,strtline->sipversion,strlen(strtline->sipversion));
  tmp = tmp + strlen(strtline->sipversion);
  sstrncpy(tmp," ",1);
  tmp = tmp + 1;
  sstrncpy(tmp,strtline->statuscode,strlen(strtline->statuscode));
  tmp = tmp + strlen(strtline->statuscode);
  sstrncpy(tmp," ",1);
  tmp = tmp + 1;
  sstrncpy(tmp,strtline->reasonphrase,strlen(strtline->reasonphrase));
  
  return 0;
}

static int
msg_startline_2char(startline_t *strtline, char **dest)
{

  if (strtline->sipmethod!=NULL)
      return startline_2charreq(strtline, dest);
  if (strtline->statuscode!=NULL)
      return startline_2charresp(strtline, dest);

  TRACE(trace(__FILE__,__LINE__,TRACE_LEVEL1,NULL,"ERROR strtline->method has no value!\n"));
  return -1; /* should never come here */
}

char *
msg_getreasonphrase(sip_t *sip)
{
  return sip->strtline->reasonphrase;
}
char *
msg_getstatuscode(sip_t *sip)
{
  return sip->strtline->statuscode;
}
char *
msg_getmethod(sip_t *sip)
{
  return sip->strtline->sipmethod;
}
char *
msg_getversion(sip_t *sip)
{
  return sip->strtline->sipversion;
}
url_t *
msg_geturi(sip_t *sip)
{
  return sip->strtline->rquri;
}

int
msg_2char(sip_t *sip, char **dest)
{
  /* ADDED at SIPit day1 */
  char *start_of_bodies;
  char *content_length_to_modify;

  char *message;
  char *tmp;
  int pos;
  int i;

  *dest = NULL;
  if ((sip==NULL)||(sip->strtline==NULL)||(sip->to==NULL)||(sip->from==NULL))
    return -1;

  message = (char *)smalloc(4000); /* ???? message could be > 4000  */
  *dest = message;

  /* add the first line of message */
  i = msg_startline_2char(sip->strtline, &tmp);
  if (i==-1) {
    sfree(*dest);
    return -1;
  }
  sstrncpy(message, tmp, strlen(tmp));
  sfree(tmp);
  message = message + strlen(message);
  sstrncpy(message, CRLF, 2);
  message = message + 2;

  /* add via headers */
  pos = 0;
  while (!list_eol(sip->vias,pos))
    {
      via_t *via;
      via = (via_t *)list_get(sip->vias,pos);
      
      sstrncpy(message,"via: ",5);
      message = message + strlen(message);
      i = via_2char(via, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
      sstrncpy(message, tmp, strlen(tmp));
      sfree(tmp);
      message = message + strlen(message);
      sstrncpy(message, CRLF, 2);
      message = message + 2;
      
      pos++;
    }


    sstrncpy(message,"from: ",6);
    message = message + strlen(message);
    i = from_2char(sip->from, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
    sstrncpy(message,tmp,strlen(tmp));
    sfree(tmp);
    message = message + strlen(message);
    sstrncpy(message,CRLF,2);
    message = message + 2;

    sstrncpy(message,"to: ",4);
    message = message + strlen(message);
    i = to_2char(sip->to, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
    sstrncpy(message,tmp,strlen(tmp));
    sfree(tmp);
    message = message + strlen(message);
    sstrncpy(message,CRLF,2);
    message = message + 2;


    sstrncpy(message,"cseq: ",6);
    message = message + strlen(message);
    i = cseq_2char(sip->cseq, &tmp);
    if (i==-1) {
      sfree(*dest);
      return -1;
    }
    sstrncpy(message,tmp,strlen(tmp));
    sfree(tmp);
    message = message + strlen(message);
    sstrncpy(message,CRLF,2);
    message = message + 2;

    sstrncpy(message,"call-id: ",9);
    message = message + strlen(message);
    i = call_id_2char(sip->call_id, &tmp);
    if (i==-1) {
      sfree(*dest);
      return -1;
    }
    sstrncpy(message,tmp,strlen(tmp));
    sfree(tmp);
    message = message + strlen(message);
    sstrncpy(message,CRLF,2);
    message = message + 2;


    pos = 0;
    while (!list_eol(sip->contacts,pos))
      {
      contact_t *contact;
      contact = (contact_t *)list_get(sip->contacts,pos);
      sstrncpy(message,"contact: ",9);
      message = message + strlen(message);
      i = contact_2char(contact, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
      sstrncpy(message,tmp,strlen(tmp));
      sfree(tmp);
      message = message + strlen(message);
      sstrncpy(message,CRLF,2);
      message = message + 2;
    
      pos++;
      }

    pos = 0;
    while (!list_eol(sip->record_routes,pos))
      {
      record_route_t *record_route;
      record_route = (record_route_t *)list_get(sip->record_routes,pos);
      sstrncpy(message,"record_route: ",14);
      message = message + strlen(message);
      i = record_route_2char(record_route, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
      sstrncpy(message,tmp,strlen(tmp));
      sfree(tmp);
      message = message + strlen(message);
      sstrncpy(message,CRLF,2);
      message = message + 2;
    
      pos++;
      }

    pos = 0;
    while (!list_eol(sip->routes,pos))
      {
      route_t *route;
      route = (route_t *)list_get(sip->routes,pos);
      sstrncpy(message,"route: ",7);
      message = message + strlen(message);
      i = route_2char(route, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
      sstrncpy(message,tmp,strlen(tmp));
      sfree(tmp);
      message = message + strlen(message);
      sstrncpy(message,CRLF,2);
      message = message + 2;
    
      pos++;
      }

    pos = 0;
    while (!list_eol(sip->headers,pos))
      {
	header_t *header;
	header = (header_t *)list_get(sip->headers,pos);
	i = header_2char(header, &tmp);
	if (i==-1) {
	  sfree(*dest);
	  return -1;
	}
	sstrncpy(message,tmp,strlen(tmp));
	sfree(tmp);      
	message = message + strlen(message);
	sstrncpy(message,CRLF,2);
	message = message + 2;
	
	pos++;
      }
    
    if (sip->content_type!=NULL)
      {
	sstrncpy(message,"content-type: ",14);
	message = message + strlen(message);
	i = content_type_2char(sip->content_type, &tmp);
	if (i==-1) {
	  sfree(*dest);
	  return -1;
	}
	sstrncpy(message,tmp,strlen(tmp));
	sfree(tmp);
	message = message + strlen(message);
	sstrncpy(message,CRLF,2);
	message = message + 2;
      }

    if (sip->mime_version!=NULL)
      {
	sstrncpy(message,"mime-version: ",14);
	message = message + strlen(message);
	i = mime_version_2char(sip->mime_version, &tmp);
	if (i==-1) {
	  sfree(*dest);
	  return -1;
	}
	sstrncpy(message,tmp,strlen(tmp));
	sfree(tmp);
	message = message + strlen(message);
	sstrncpy(message,CRLF,2);
	message = message + 2;
      }

    /* we have to create the body before adding the contentlength */

    sstrncpy(message,"content-length: ",16);
    message = message + strlen(message);

    /* SIPit Day1
       ALWAYS RECALCULATE?
      if (sip->contentlength!=NULL)
      {
	i = content_length_2char(sip->contentlength, &tmp);
	if (i==-1) {
	  sfree(*dest);
	  return -1;
	}
	sstrncpy(message,tmp,strlen(tmp));
	sfree(tmp);
      }
    else
    { */
    if (list_eol(sip->bodies,0)) /* no body */
	sstrncpy(message,"0",1);
    else
      {
	sstrncpy(message,"xxxxx",5);
	content_length_to_modify = message;
      }
    /*  } */
    message = message + strlen(message);
    sstrncpy(message,CRLF,2);
    message = message + 2;


    /* end of headers */
    sstrncpy(message,CRLF,2);
    message = message + 2;

    if (list_eol(sip->bodies,0))
      return 0; /* it's all done */

    start_of_bodies = message;

    pos = 0;
    while (!list_eol(sip->bodies,pos))
      {
      body_t *body;
      body = (body_t *)list_get(sip->bodies,pos);

      if (sip->mime_version!=NULL)
	{
	  sstrncpy(message,"--++",strlen("--++"));
	  message = message + strlen(message);
	  sstrncpy(message,CRLF,2);
	  message = message + 2;
	}
      
      i = body_2char(body, &tmp);
      if (i==-1) {
	sfree(*dest);
	return -1;
      }
      sstrncpy(message,tmp,strlen(tmp));
      sfree(tmp);
      message = message + strlen(message);
      
      pos++;
      }

      if (sip->mime_version!=NULL)
	{
	  sstrncpy(message,"--++--",strlen("--++--"));
	  message = message + strlen(message);
	  sstrncpy(message,CRLF,2);
	  message = message + 2;
	  /* ADDED at SIPit day1:  Is this needed for MIME type?
	     sstrncpy(message,CRLF,2);
	     message = message + 2;
	     strncpy(message,"\0",1); */
	}

      /* we NOW have the length of bodies: */
      {
	int size = strlen(start_of_bodies);
	/* replace xxxxx by size */
	tmp = (char *)smalloc(15);
	/* to be improved? */
	sprintf(tmp,"%i     ",size);
	/* do not use sstrncpy here! */
	strncpy(content_length_to_modify,tmp,5);
	sfree(tmp);
      }

  return 0;
}

#ifdef ENABLE_TRACE

void
msg_logresponse(sip_t *sip,char *fmt)
{
  char *tmp1;
  char *tmp2;
  int i;
  i = msg_2char(sip, &tmp1);
  if (i!=-1)
    {
      trace(__FILE__,__LINE__,TRACE_LEVEL4,stdout,"<app.c> MESSAGE :\n%s\n",tmp1);
      sfree(tmp1);
    }
  else
      trace(__FILE__,__LINE__,TRACE_LEVEL4,stdout,"<app.c> MESSAGE :\n Could not make a string of message\n");

  i = from_2char(sip->from, &tmp1);
  if (i==-1)
    return ;
  i = to_2char(sip->to, &tmp2);
  if (i==-1)  
    return ;

  trace(__FILE__,__LINE__,TRACE_LEVEL0,NULL,fmt,sip->strtline->statuscode,sip->strtline->reasonphrase,sip->cseq->method,tmp1,tmp2,sip->cseq->number,sip->call_id->number);

  sfree(tmp1);
  sfree(tmp2);
}

void
msg_logrequest(sip_t *sip,char *fmt)
{
  char *tmp1;
  char *tmp2;
  int i;

  i = msg_2char(sip, &tmp1);
  if (i!=-1)
    {
      trace(__FILE__,__LINE__,TRACE_LEVEL4,stdout,"<app.c> MESSAGE :\n%s\n",tmp1);
      sfree(tmp1);
    }
  else
      trace(__FILE__,__LINE__,TRACE_LEVEL4,stdout,"<app.c> MESSAGE :\n Could not make a string of message\n");

  i = from_2char(sip->from, &tmp1);
  if (i==-1)
    return ;
  i = to_2char(sip->to, &tmp2);
  if (i==-1)
    return ;

  trace(__FILE__,__LINE__,TRACE_LEVEL0,NULL,fmt,sip->cseq->method
      ,tmp1,tmp2
      ,sip->cseq->number,sip->call_id->number);
  sfree(tmp1);
  sfree(tmp2);
}

#endif
