/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <osip/osip.h>
#include <osip/port.h>


int
osip_init(osip_t **osip)
{
  *osip = (osip_t *)smalloc(sizeof(osip_t));
  if (*osip==NULL)
    return -1; /* allocation failed */

  /* list of current transactions */
  (*osip)->transactions    = (list_t *) smalloc(sizeof(list_t));
  list_init((*osip)->transactions);

  /* default behavior: do not use a proxy */
  (*osip)->proxy = NULL;

  (*osip)->cb_rcvinvite = NULL;
  (*osip)->cb_rcvack = NULL;
  (*osip)->cb_rcvbye = NULL;
  (*osip)->cb_rcvcancel = NULL;
  (*osip)->cb_rcvinfo = NULL;
  (*osip)->cb_rcvoptions = NULL;
  (*osip)->cb_rcvregister = NULL;
  (*osip)->cb_rcvprack = NULL;
  (*osip)->cb_rcvunkrequest = NULL;

  (*osip)->cb_snd1xx = NULL;
  (*osip)->cb_snd2xx = NULL;
  (*osip)->cb_snd3xx = NULL;
  (*osip)->cb_snd4xx = NULL;
  (*osip)->cb_snd5xx = NULL;
  (*osip)->cb_snd6xx = NULL;

  (*osip)->cb_sndinvite = NULL;
  (*osip)->cb_sndack = NULL;
  (*osip)->cb_sndbye = NULL;
  (*osip)->cb_sndcancel = NULL;
  (*osip)->cb_sndinfo = NULL;
  (*osip)->cb_sndoptions = NULL;
  (*osip)->cb_sndregister = NULL;
  (*osip)->cb_sndprack = NULL;
  (*osip)->cb_sndunkrequest = NULL;

  (*osip)->cb_rcv1xx = NULL;
  (*osip)->cb_rcv2xx = NULL;
  (*osip)->cb_rcv3xx = NULL;
  (*osip)->cb_rcv4xx = NULL;
  (*osip)->cb_rcv5xx = NULL;
  (*osip)->cb_rcv6xx = NULL;

  (*osip)->cb_rcvresp_retransmission = NULL;
  (*osip)->cb_sndreq_retransmission = NULL;
  (*osip)->cb_sndresp_retransmission = NULL;
  (*osip)->cb_rcvreq_retransmission = NULL;

  (*osip)->cb_killtransaction = NULL;
  (*osip)->cb_endoftransaction = NULL;

  (*osip)->cb_connection_refused = NULL;
  (*osip)->cb_network_error = NULL;

  return 0;
}

int
osip_init_timers(osip_t *osip)
{
  /* timers for uac and uas transactions. */
  osip->uac_timerff   = (fifo_t *)smalloc(sizeof(fifo_t));
  osip->uas_timerff   = (fifo_t *)smalloc(sizeof(fifo_t));
  fifo_init(osip->uac_timerff);
  fifo_init(osip->uas_timerff);

  /* timers for uac and uas transactions. */
  osip->uas_transactions  = (list_t *)smalloc(sizeof(list_t));
  list_init(osip->uas_transactions);
  osip->uac_transactions  = (list_t *)smalloc(sizeof(list_t));
  list_init(osip->uac_transactions);
  return 0;
}

void
osip_init_proxy(osip_t *osip, url_t *prox)
{
  osip->proxy = prox;
}

int
osip_execute(osip_t *config)
{
  transaction_t *transaction;
  sipevent_t *se;
  int more_event;
  int tr,ev;
  tr=0;
  ev=0;
  while (!list_eol(config->transactions,tr))
    {
      transaction = list_get(config->transactions,tr);
      tr++;
      more_event = 1;
      do
	{
	  se = (sipevent_t *)fifo_tryget(transaction->transactionff);
	  
	  if (se==NULL) /* no more event for this transaction */
	    {
	      /* continue with next transaction, and its first event */
	      ev = 0;
	      more_event=0;   
	    }
	  else
	    {
	      transaction_execute(transaction,se);
	    }
	} while (more_event==1);
    }
  return 0;
}


void osip_setcb_killtransaction  (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_killtransaction = cb;
}

void osip_setcb_endoftransaction  (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_endoftransaction = cb;
}

void osip_setcb_connection_refused  (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_connection_refused = cb;
}

void osip_setcb_network_error  (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_network_error = cb;
}

void osip_setcb_rcvreq_retransmission  (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_rcvreq_retransmission = cb;
}

void osip_setcb_sndreq_retransmission (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_sndreq_retransmission = cb;
}

void osip_setcb_sndresp_retransmission     (osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_sndresp_retransmission = cb;
}

void osip_setcb_rcvresp_retransmission(osip_t *cf,void (*cb)(transaction_t*))
{
  cf->cb_rcvresp_retransmission = cb;
}

void osip_setcb_rcvinvite  (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvinvite = cb;
}

void osip_setcb_rcvack     (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvack = cb;
}

void osip_setcb_rcvbye     (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvbye = cb;
}

void osip_setcb_rcvcancel  (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvcancel = cb;
}

void osip_setcb_rcvinfo    (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvinfo = cb;
}
void osip_setcb_rcvoptions (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvoptions = cb;
}
void osip_setcb_rcvregister(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvregister = cb;
}
void osip_setcb_rcvprack   (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvprack = cb;
}
void osip_setcb_rcvunkrequest(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcvunkrequest = cb;
}

void osip_setcb_sndinvite  (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndinvite = cb;
}
void osip_setcb_sndack     (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndack = cb;
}
void osip_setcb_sndbye     (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndbye = cb;
}
void osip_setcb_sndcancel  (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndcancel = cb;
}
void osip_setcb_sndinfo    (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndinfo = cb;
}
void osip_setcb_sndoptions (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndoptions = cb;
}
void osip_setcb_sndregister(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndregister = cb;
}
void osip_setcb_sndprack   (osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndprack = cb;
}
void osip_setcb_sndunkrequest(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_sndunkrequest = cb;
}

void osip_setcb_rcv1xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv1xx = cb;
}
void osip_setcb_rcv2xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv2xx = cb;
}
void osip_setcb_rcv3xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv3xx = cb;
}
void osip_setcb_rcv4xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv4xx = cb;
}
void osip_setcb_rcv5xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv5xx = cb;
}

void osip_setcb_rcv6xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_rcv6xx = cb;
}

void osip_setcb_snd1xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd1xx = cb;
}
void osip_setcb_snd2xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd2xx = cb;
}
void osip_setcb_snd3xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd3xx = cb;
}
void osip_setcb_snd4xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd4xx = cb;
}
void osip_setcb_snd5xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd5xx = cb;
}
void osip_setcb_snd6xx(osip_t *cf,void (*cb)(sipevent_t*,transaction_t*))
{
  cf->cb_snd6xx = cb;
}

