

#ifndef _SDP_H_
#define _SDP_H_

#include <osip/port.h>


#define SDP_SYNTAXERROR -1;


#define IS_V_FIELD( P ) ((P!=NULL)&&(0==strncmp("v",P,1)))
#define IS_O_FIELD( P ) ((P!=NULL)&&(0==strncmp("o",P,1)))
#define IS_S_FIELD( P ) ((P!=NULL)&&(0==strncmp("s",P,1)))
#define IS_I_FIELD( P ) ((P!=NULL)&&(0==strncmp("i",P,1)))
#define IS_U_FIELD( P ) ((P!=NULL)&&(0==strncmp("u",P,1)))
#define IS_E_FIELD( P ) ((P!=NULL)&&(0==strncmp("e",P,1)))
#define IS_P_FIELD( P ) ((P!=NULL)&&(0==strncmp("p",P,1)))
#define IS_C_FIELD( P ) ((P!=NULL)&&(0==strncmp("c",P,1)))
#define IS_B_FIELD( P ) ((P!=NULL)&&(0==strncmp("b",P,1)))
#define IS_T_FIELD( P ) ((P!=NULL)&&(0==strncmp("t",P,1)))
#define IS_R_FIELD( P ) ((P!=NULL)&&(0==strncmp("r",P,1)))
#define IS_Z_FIELD( P ) ((P!=NULL)&&(0==strncmp("z",P,1)))
#define IS_K_FIELD( P ) ((P!=NULL)&&(0==strncmp("k",P,1)))
#define IS_A_FIELD( P ) ((P!=NULL)&&(0==strncmp("a",P,1)))
#define IS_M_FIELD( P ) ((P!=NULL)&&(0==strncmp("m",P,1)))

#define FREE_V_FIELD( P ) if (P->v!=NULL) sfree(P->v)
#define FREE_O_FIELD( P ) if (P->o!=NULL) sfree(P->o)
#define FREE_S_FIELD( P ) if (P->s!=NULL) sfree(P->s)
#define FREE_I_FIELD( P ) if (P->i!=NULL) sfree(P->i)
#define FREE_U_FIELD( P ) if (P->u!=NULL) sfree(P->u)
#define FREE_E_FIELDS( P ) listofchar_free(P->es);sfree(P->es)
#define FREE_P_FIELDS( P ) listofchar_free(P->ps);sfree(P->ps)
#define FREE_C_FIELD( P ) if (P->c!=NULL) sfree(P->c)
#define FREE_B_FIELDS( P ) listofchar_free(P->bs);sfree(P->bs)
#define FREE_TIMED_FIELD( TD ) timed_free(TD)
#define FREE_T_FIELD( TD ) if (TD->t!=NULL) sfree(TD->t)
#define FREE_R_FIELDS( TD) listofchar_free(TD->rs);sfree(TD->rs)
#define FREE_Z_FIELD( P ) if (P->z!=NULL) sfree(P->z)
#define FREE_K_FIELD( P ) if (P->k!=NULL) sfree(P->k)
#define FREE_A_FIELDS( Q ) listofchar_free(Q->as);sfree(Q->as)
#define FREE_MEDIAD_FIELD( MD ) mediad_free(MD)
#define FREE_M_FIELD( MD ) if (MD->m!=NULL) sfree(MD->m)
#define FREE_C_FIELDS( MD ) listofchar_free(MD->cs);sfree(MD->cs)

typedef struct _o_sdp_t {
  char *username;
  char *t1;
  char *t2;
  char *network_type;
  char *network_version;
  char *ip_of_originator;
} o_sdp_t;
/*
typedef struct _e_sdp_t {
  email_t *email;
}
*/
typedef struct _t_sdp_t {
  char *t1;
  char *t2;
} t_sdp_t;

typedef struct _c_sdp_t {
  char *network_type;
  char *network_version;
  char *ip_of_originator;
} c_sdp_t;

typedef struct _m_sdp_t {
  char   *type;
  char   *port;
  char   *protocol;
  list_t *payloads;
} _m_sdp_t;

typedef struct _a_sdp_t {
  char   *line;
} _a_sdp_t;

typedef struct _sdp_t {

  list_t *audio_payload;
  list_t *video_payload;
  list_t *applications;

  char *v;
  char *o;
  char *s;
  char *i;         /* MAY be NULL */
  char *u;         /* MAY be NULL */
  list_t *es;      /* list_size MAY be 0 */
  list_t *ps;      /* list_size MAY be 0 */
  char *c;         /* MAY be NULL */
  list_t *bs;      /* list_size MAY be 0 */

  list_t *timeds;  /* (list_size MUST be => 1) */

  char *z;         /* MAY be NULL */
  char *k;         /* MAY be NULL */
  list_t *as;      /* (list_size MUST be => 1) */

  list_t *mediads; /* list_size MAY be 0 */
  
} sdp_t;

typedef struct _timed_t {

  char *t;
  list_t *rs;       /* list_size MAY be 0 */

} timed_t;

typedef struct _mediad_t {
  
  char *m;
  char *i;
  list_t *cs; /* list_size MAY be 0 (if global c exists)*/
  list_t *bs; /* list_size MAY be 0 */
  char *k;
  list_t *as; /* list_size MAY be 0 */

} mediad_t;

void      mediad_init            (mediad_t *mediad);
int       mediad_getpayload(mediad_t *mediad   ,int pos);
int       mediad_replyto         (mediad_t *remote_media
				  ,mediad_t *local_media);

void   timed_init        (timed_t *timed);

void   sdp_init          (sdp_t *sdp);
void   sdp_setproperties (sdp_t *sdp            ,list_t *audio_payload,
			  list_t *video_payload ,list_t *applications);
char  *sdp_2char         (sdp_t *sdp);
void   sdp_free          (sdp_t *sdp);
int    sdp_replyto       (sdp_t *sdp_remote,sdp_t *dest,
			  char *username,char *networktype,
			  char *addr_type,char *localip);


int    sdp_parse         (sdp_t *sdp       ,const char *buf);
int    sdp_gotonextline  (const char *buf  ,int pos);
char  *sdp_readfieldname (const char *buf  ,int pos);
char  *sdp_readfieldvalue(const char *buf  ,int pos);

#endif
