/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>

#include <osip/smsg.h>
#include <osip/port.h>

int test_message(char *msg);


int
main(int argc, char **argv)
{
  int i;
  char *marker;
  FILE *torture_file;
  FILE *logfile;
  char *tmp;
  char *msg;
  char *tmpmsg;
  static int num_test = 0;
  logfile = fopen("siplog_test", "w");
  TRACE_INITIALIZE(2,logfile);

  torture_file = fopen(argv[1],"r");
  if (torture_file==NULL)
    {
    fprintf(stdout,"Failed to open \"torture_msgs\" file.\nUsage: torture torture_file\n");
    exit(0);
    }

  /* initialize parser */
  parser_init();

  i = 0;
  tmp = (char *)smalloc(500);
  marker = fgets(tmp,500,torture_file); /* lines are under 500 */
  fprintf(stdout,"message number: %s\n",argv[2]);
  while (marker!=NULL&&i<atoi(argv[2]))
    {
      if (0==strncmp(tmp,"|",1))
	i++;
      marker = fgets(tmp,500,torture_file);
    }

    num_test++;

    msg = (char *)smalloc(10000);/* msg are under 10000 */
    tmpmsg = msg;

    if (marker==NULL)
      {
	fprintf(stdout,"Error! The message's number you specified does not exist");
	exit(0);  /* end of file detected! */
      }
    /* this part reads an entire message, separator is "|" (it is */
    /*  unlinkely that it will appear in messages! */
    while (marker!=NULL&&strncmp(tmp,"|",1))
      {
      sstrncpy(tmpmsg,tmp,strlen(tmp));
      tmpmsg = tmpmsg + strlen(tmp);
      marker = fgets(tmp,500,torture_file);
      }

    fprintf(stdout,"test %s : ============================ \n",argv[2]);
    fprintf(stdout,"%s",msg);
      
    if (0==test_message(msg))
      fprintf(stdout,"test %s : ============================ OK\n",argv[2]);
    else
      fprintf(stdout,"test %s : ============================ KKKKKKKKKKO\n",argv[2]);
    sfree(msg);
  sfree(tmp);

  fclose(logfile );
  return 1;

}

int
test_message(char *msg)
{
  sip_t *sip;
  
  {
    char *result;

    msg_init(&sip);
    if (msg_parse(sip, msg)!=0)
      {
      fprintf(stdout,"ERROR: failed while parsing!\n");
      msg_free(sip);  /* try to free msg, even if it failed! */
      /* this seems dangerous..... */
      return -1;
      }
    else
      {
	int i;
	i = msg_2char(sip, &result);
	if (i == -1)
	  {
	  fprintf(stdout,"ERROR: failed while printing message!\n");
	  msg_free(sip);
	  return -1;
	  }
	else {
	  sfree(result);
	  fprintf(stdout,"%s",result);
	}
	msg_free(sip);
	sfree(sip);
      }
  }
  return 0;
}
