/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc2543-)
  Copyright (C) 2001  Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <osip/port.h>
#include <osip/osip.h>

#include "fsm.h"

int
nist_init(nist_t **nist, osip_t *osip, sip_t *invite)
{
  int i;

  TRACE(trace(__FILE__,__LINE__,TRACE_LEVEL3,NULL,"INFO: allocating NIST context\n"));

  *nist = (nist_t *)smalloc(sizeof(nist_t));
  if (*nist==NULL) return -1;

#ifndef DISABLE_MEMSET
  memset(*nist, 0, sizeof(nist_t));
#endif
  /* for INVITE retransmissions */
  {
    via_t *via;
    char  *proto;
    i = msg_getvia(invite, 0, &via); /* get top via */
    if (i!=0) goto ii_error_1;
    proto = via_getprotocol(via);
    if (proto==NULL) goto ii_error_1;

#ifndef WIN32
    i = strncasecmp(proto, "TCP", 3);
#else
    i = stricmp(proto, "TCP");
#endif
    if (i!=0)
      { /* for other reliable protocol than TCP, the timer
	   must be desactived by the external application */
	(*nist)->timer_j_length = 64 * DEFAULT_T1;
	(*nist)->timer_j_start = -1;  /* not started */
      }
    else
      { /* TCP is used: */
	(*nist)->timer_j_length = 0; /* MUST do the transition immediatly */
	(*nist)->timer_j_start = -1; /* not started */
      }
  }

  return 0;

 ii_error_1:
  sfree(*nist);
  return -1;
}

int
nist_free(nist_t *nist)
{
  if (nist==NULL) return -1;
  TRACE(trace(__FILE__,__LINE__,TRACE_LEVEL3,NULL,"INFO: free nist ressource\n"));

  return 0;
}


sipevent_t *
nist_need_timer_j_event(nist_t *nist, state_t state, int transactionid)
{
  time_t now = time(NULL);
  if (nist==NULL) return NULL;
  if (state==NIST_COMPLETED)
    {
      if (nist->timer_j_start==-1) return NULL;
      if ((now-nist->timer_j_start)*1000>nist->timer_j_length)
	return osip_new_event(TIMEOUT_J, transactionid);
    }
  return NULL;
}
