///////////////////////////////////////////////////////////////////////////////
// Project    : libswf v0.1
// Module     : nc_swf_encode.hpp
// Author     : Eduardo Aguiar - 2000.08.27
// Description: class definition
///////////////////////////////////////////////////////////////////////////////
#ifndef def_nc_swf_encode
#define def_nc_swf_encode

#include <stdio.h>
#include <queue>
#include "typestring.hpp"

typedef unsigned char byte;
typedef unsigned short int word;
typedef unsigned int dword;

class nc_swf_encode {

private:
   int i_errno;                         // error number
   typestring i_errtext;                // error text 

   FILE *fileswf;                       // file pointer
   fpos_t i_pos_framecount;             // position of framecount
   int i_framecount;                    // framecount

   byte i_encodebitmask;                // bit encoding variables
   byte i_encodebitchar;

   int i_tagid;                         // TAG id
   queue <byte> tag;                    // TAG temporary area
   

public:
   nc_swf_encode(void);
  ~nc_swf_encode(void);
   void create(const typestring& filename,int,int,int,int);
   void close(void);

   void TAGend(void);
   void TAGshowframe(void);
   void TAGsetbgcolor(byte,byte,byte);

private:
   void encodeUI8(byte);
   void encodeUI16(word);
   void encodeUI32(dword);
   void encodeRGB(byte,byte,byte);
   void encodeRGBA(byte,byte,byte,byte);
   void encodeRECT(int,int,int,int);
   void encodebitstart(void);
   void encodebitend(void);
   void encodebit(byte);
   void encodeUB(int,dword);
   void encodeSB(int,int);
   void encodeblock(byte *,int);
   void encodetagstart(dword);
   void encodetagend();
   int  getbitsofvalue(int);
};

#endif
