///////////////////////////////////////////////////////////////////////////////
// Project    : libswf v0.1
// Module     : nc_swf_encode_tag.cpp
// Author     : Eduardo Aguiar - 2000.08.27
// Description: TAG encoding module
///////////////////////////////////////////////////////////////////////////////
#include "nc_swf_encode.hpp"


///////////////////////////////////////////////////////////////////////////////
// Method     : TAGend
// Description: END (tagid = 0)
// Parameters : none
// Returns    : none
///////////////////////////////////////////////////////////////////////////////
void nc_swf_encode::TAGend(void){
   encodetagstart(0);
   encodetagend();
}

///////////////////////////////////////////////////////////////////////////////
// Method     : TAGshowframe
// Description: SHOWFRAME (tagid = 1)
// Parameters : none
// Returns    : none
///////////////////////////////////////////////////////////////////////////////
void nc_swf_encode::TAGshowframe(void){
   encodetagstart(1);
   encodetagend();
   i_framecount++;   
}

///////////////////////////////////////////////////////////////////////////////
// Method     : TAGsetbgcolor
// Description: SETBACKGROUND COLOR (tagid = 9)
// Parameters : R,G,B (color)
// Returns    : none
///////////////////////////////////////////////////////////////////////////////
void nc_swf_encode::TAGsetbgcolor(byte r,byte g,byte b){
   encodetagstart(9);
   encodeRGB(r,g,b);
   encodetagend();
}
