//============================================================================
// typestring (ANSI) -- string manipulation object
// by Eduardo Aguiar (aguiar@uerj.br, eduardo.aguiar@zipmail.com.br)
//
// operators (>), (<) , (>=), (<=) , (!=) , (==) revised by Antonio Chay
// Any doubt, please contact author
//============================================================================

//============================================================================
// Includes e defines
//============================================================================
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <regex.h>
#include "typestring.hpp"

//============================================================================
// Funcoes basicas de manipulacao de strings
//============================================================================
static int  __strlen(const char *);
static void __strcpy(char *,const char *);
static void __strncpy(char *,const char *,int);
static void __strcat(char *,const char *);
static int  __strcmp(const char *,const char *);
static void __strupr(char *);
static void __strlwr(char *);
static int  __strind(const char *,const char);
static int  __strloc(const char *, const char *);
static void __strdate(int *,int *,int *);
static void __strtime(int *,int *,int *);
static int  __strvfy(const char *,const char *);
static void __stralignleft(char *,const char *,int,char);
static void __stralignright(char *,const char *,int,char);
static int  __strmask(const char *,const char *);
static void __stritoa(char *,int);



//============================================================================
// Construtores. Inicializam o objeto de varias formas
//============================================================================
// typestring str;          -> inicializa uma string nula ("")
// typestring str = "texto" -> inicializa uma string com char *
// typestring str = 'a'     -> inicializa uma string com um caracter
// typestring str(typestring)-> construtora de copia. Usada pelo C++
//    para retorno de parametros typestring entre funcoes.
//============================================================================
typestring::typestring(void) : text(NULL){           // string = ""
   text = new char[1];
   text[0] = '\0';
}
typestring::typestring(const char *s) : text(NULL){  // string = char *
   text = new char[__strlen(s) + 1];
   __strcpy(text,s);
}
typestring::typestring(const char c) : text(NULL){   // string = char
   text = new char[2];
   text[0] = c;
   text[1] = '\0';
}
typestring::typestring(const typestring& str) : text(NULL){ // Construtor de copia
   text = new char[__strlen(str.text) + 1];
   __strcpy(text,str.text);
}
typestring::typestring(int num): text(NULL){
   text = new char[30];
   __stritoa(text,num);
}

//============================================================================
// Destrutor. Destroi objeto liberando memoria alocada pelo array
//============================================================================
typestring::~typestring(void){
   delete [] text;
}

//============================================================================
// __stralloc. Aloca espaco para caracteres no objeto dado
//============================================================================
void typestring::__stralloc(int cs){
   if (cs < 0) return;
   if (cs == __strlen(text)) return;

   delete [] text;
   text = new char[cs+1];
}

//============================================================================
// Operadores de comparacao
//============================================================================
// typestring == typestring
// typestring != typestring
// typestring >  typestring 
// typestring <  typestring 
// typestring >= typestring
// typestring <= typestring
//============================================================================
int operator == (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) == 0) return 1;
   return 0;
}
int operator != (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) == 0) return 0;
   return 1;
}
int operator > (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) > 0) return 1;
   return 0;
}
int operator < (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) < 0) return 1;
   return 0;
}
int operator >= (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) >= 0) return 1;
   return 0;
}
int operator <= (const typestring& str1,const typestring& str2){
   if (__strcmp(str1.text,str2.text) <= 0) return 1;
   return 0;
}

//============================================================================
// Operador de atribuicao (=)
//============================================================================
typestring& typestring::operator = (const typestring& str){
   __stralloc(__strlen(str.text));
   __strcpy(text,str.text);

   return *this;
}

//============================================================================
// Operadores de concatenacao (+)
//============================================================================
typestring operator + (const typestring& s1,const typestring& s2){
   typestring strtmp;
   strtmp.__stralloc(__strlen(s1.text) + __strlen(s2.text));
   __strcpy(strtmp.text,s1.text);
   __strcat(strtmp.text,s2.text);

   return strtmp;
}
typestring operator + (const char *s,const typestring& str){
   typestring strtmp;
   strtmp.__stralloc(__strlen(s) + __strlen(str.text));
   __strcpy(strtmp.text,s);
   __strcat(strtmp.text,str.text);

   return strtmp;
}
typestring operator + (const char c,const typestring& str){
   typestring strtmp;
   strtmp.__stralloc(__strlen(str.text) + 1);
   strtmp.text[0] = c;
   __strcat(strtmp.text,str.text);

   return strtmp;
}
typestring operator + (int num, const typestring& str){
   char s[16];
   __stritoa(s,num);

   typestring strtmp;
   strtmp.__stralloc(__strlen(str.text) + __strlen(s));
   __strcpy(strtmp.text,s);
   __strcat(strtmp.text,str.text);

   return strtmp;
}
typestring typestring::operator += (const typestring& str){
   int siz = __strlen(text);
   char buftmp[siz+1];
   __strcpy(buftmp,text);
   __stralloc(siz + __strlen(str.text));
   __strcpy(text,buftmp);
   __strcat(text,str.text);

   return *this;
}

//============================================================================
// operator ! - Retorna um ponteiro char *
//============================================================================
const char *operator ! (const typestring& str){
  return str.text;
}

//============================================================================
// chars() -- conversor typestring -> char *
//============================================================================
const char *chars(const typestring& str){
   return str.text;
}


//============================================================================
// CLASS MANIPULATION FUNCTIONS
//============================================================================

//============================================================================
// strlength
//============================================================================
int strlength(const typestring& str){
   return __strlen(str.text);
}

//============================================================================
// strsub(pos)
//============================================================================
typestring strsub(const typestring& str,int pos){
   int len = __strlen(str.text);
   if (pos < 1 || pos > len) return "";

   return strsub(str,pos,len - pos + 1);
}

//============================================================================
// strsub(pos,siz)
//============================================================================
typestring strsub(const typestring& str,int pos,int siz){
   int len = __strlen(str.text);   
   if ((pos < 1) || (pos > len) || (siz < 1)) return "";
   if (pos + siz - 1 >= len) siz = len - pos + 1;

   typestring strtmp;
   strtmp.__stralloc(siz);
   __strncpy(strtmp.text,str.text + pos - 1,siz);

   return strtmp;
}

//============================================================================
// strleft
//============================================================================
typestring strleft(const typestring& str,int siz){
   int len = __strlen(str.text);   

   if (siz < 1) return "";
   else if (siz >= len) return str;

   return strsub(str,1,siz);
}

//============================================================================
// strright
//============================================================================
typestring strright(const typestring& str,int siz){
   int len = __strlen(str.text);   
   int pos = (len - siz) + 1;

   if (siz < 1) return "";
   else if (siz >= len) return str;

   return strsub(str,pos,siz);
}

//============================================================================
// strupper
//============================================================================
typestring strupper(const typestring& str){
   typestring strtmp = str;
   __strupr(strtmp.text);
   return strtmp;
}

//============================================================================
// strlower
//============================================================================
typestring strlower(const typestring& str){
   typestring strtmp = str;
   __strlwr(strtmp.text);
   return strtmp;
}

//============================================================================
// strdate
//============================================================================
typestring strdate(const typestring& type){
   int da_day,da_mon,da_year;
   __strdate(&da_day,&da_mon,&da_year);

   typestring utype = strupper(type);
   if (utype == 'U')  return stringf("%4d%02d%02d",da_year,da_mon,da_day);
   if (utype == 'E')  return stringf("%02d/%02d/%04d",da_day,da_mon,da_year);
   if (utype == "ES") return stringf("%d/%d/%d",da_day,da_mon,da_year);
   if (utype == 'A')  return stringf("%02d/%02d/%04d",da_mon,da_day,da_year);
   if (utype == "AS") return stringf("%d/%d/%d",da_mon,da_day,da_year);

   return "";
}

//============================================================================
// strtime
//============================================================================
typestring strtime(void){
   int h,m,s;
   __strtime(&h,&m,&s);

   return stringf("%02d:%02d:%02d",h,m,s);
}

//============================================================================
// strstrip
//============================================================================
typestring strstrip(const typestring& str){
   char *p = str.text;

   int l = 0;
   int r = __strlen(p) - 1;
   while((l <= r)&&(p[l] <= ' ')) l++;
   while((r >= l)&&(p[r] <= ' ')) r--;

   return strsub(str,l+1,r-l+1);
}

//============================================================================
// strlstrip
//============================================================================
typestring strlstrip(const typestring& str){
   char *p = str.text;

   int l = 0;
   int r = __strlen(p) - 1;
   while((l <= r)&&(p[l] <= ' ')) l++;

   return strsub(str,l+1,r-l+1);
}

//============================================================================
// strrstrip
//============================================================================
typestring strrstrip(const typestring& str){
   char *p = str.text;

   int l = 0;
   int r = __strlen(p) - 1;
   while((r >= l)&&(p[r] <= ' ')) r--;

   return strsub(str,l+1,r-l+1);
}

//============================================================================
// strindex
//============================================================================
int strindex(const typestring& str,char c){
   return __strind(str.text,c);
}

//============================================================================
// strlocate
//============================================================================
int strlocate(const typestring& str,const typestring& sub){
   return __strloc(str.text,sub.text);
}

//============================================================================
// strverify
//============================================================================
int strverify(const typestring& str,const typestring& cnt){
   if (__strlen(str.text) == 0) return -1;
   if (__strlen(cnt.text) == 0) return -1;
   return __strvfy(str.text,cnt.text);
}

//============================================================================
// strcopies
//============================================================================
typestring strcopies(const typestring& str,int count){
   int len = __strlen(str.text);
   if (len == 0 || count < 1) return "";

   //=========================================================================
   // Generate copies of *this
   //=========================================================================
   typestring strtmp;
   strtmp.__stralloc(len * count);
   strtmp.text[0] = 0;

   while(count > 0){
      __strcat(strtmp.text,str.text);
      count = count - 1;
   }

   return strtmp;
}

//============================================================================
// strtoint
//============================================================================
int strtoint(const typestring& str){
   return atoi(str.text);
}

//============================================================================
// strwords
//============================================================================
int strwords(const typestring& str,const typestring& sep){

   //========================================================================= 
   // Verifica se os parametros sao validos
   //=========================================================================
   int len = __strlen(sep.text);
   if (__strlen(str.text) == 0 || len == 0) return 0;

   //=========================================================================
   // Conta numero de palavras da string
   //=========================================================================
   int count = 1;
   int pos = 0;
   int idx = __strloc(str.text,sep.text);

   while(idx != 0){
      count = count + 1;
      pos = pos + idx + len - 1; 
      idx = __strloc(str.text + pos,sep.text);
   }

   return count;
}

//============================================================================
// strword
//============================================================================
typestring strword(const typestring& str,int wordnum,const typestring& sep){

   //=========================================================================
   // Verifica se os parametros sao validos
   //=========================================================================
   int len = __strlen(sep.text);
   if (__strlen(str.text) == 0 || len == 0) return "";
   if (wordnum < 1) return ""; 

   //=========================================================================
   // Conta numero de palavras da string
   //=========================================================================
   int count = 1;
   int pos = 0;
   int idx = __strloc(str.text,sep.text);

   while(idx != 0 && count != wordnum){
      count = count + 1;
      pos = pos + idx + len - 1; 
      idx = __strloc(str.text+pos,sep.text);
   }

   //=========================================================================
   // Verifica se encontrou a palavra
   //========================================================================= 
   if (count == wordnum){
      if (idx != 0) return strsub(str,pos+1,idx-1);
      else return strsub(str,pos+1);
   }

   return "";
}

//============================================================================
// strnword(pos)
//============================================================================
typestring strnword(const typestring& str,int wordnum,const typestring& sep){

   //=========================================================================
   // Verifica se os parametros sao validos
   //=========================================================================
   int len = __strlen(sep.text);
   if (__strlen(str.text) == 0 || len == 0) return "";
   if (wordnum < 1) return ""; 

   //=========================================================================
   // Conta numero de palavras da string
   //=========================================================================
   int count = 1;
   int pos = 0;
   int idx = __strloc(str.text,sep.text);

   while(idx != 0 && count != wordnum){
      count = count + 1;
      pos = pos + idx + len - 1; 
      idx = __strloc(str.text+pos,sep.text);
   }

   //=========================================================================
   // Verifica se encontrou a palavra
   //========================================================================= 
   if (count == wordnum) return strsub(str,pos+1);

   return "";
}

//============================================================================
// strsqueeze
//============================================================================
typestring strsqueeze(const typestring& str){
   int i;
   int len = strlen(str.text);
   int flg = 0;
   int idx = 0;

   //=========================================================================
   // Calcula tamanho da string resultante
   //=========================================================================
   for(i = 0;i < len;i++){

      if (str.text[i] <= 32){
         if (flg != 0) flg = 2;
      } 
      else{
         if (flg == 2) idx++;
         idx++;
         flg = 1;
      } 
   }   

   //=========================================================================
   // Cria string
   //=========================================================================
   typestring strtmp;
   strtmp.__stralloc(idx);

   flg = 0;
   idx = 0;

   for(i = 0;i < len;i++){
      
      if (str.text[i] <= 32){
         if (flg != 0) flg = 2;
      }
      else{
         if (flg == 2){
            strtmp.text[idx] = ' ';
            idx++;
         }
         strtmp.text[idx] = str.text[i];
         idx++;
         flg = 1;
      }
   }
   strtmp.text[idx] = 0;

   return strtmp; 
}

//============================================================================
// stralignleft
//============================================================================
typestring stralignleft(const typestring& str,int siz, char fill){
   int len = __strlen(str.text);
   if (siz < 1 || len == 0) return "";

   typestring strtmp;
   strtmp.__stralloc((len>siz)?len:siz);
   __stralignleft(strtmp.text,str.text,siz,fill);

   return strtmp;
}

//============================================================================
// stralignright
//============================================================================
typestring stralignright(const typestring& str,int siz, char fill){
   int len = __strlen(str.text);
   if (siz < 1 || len == 0) return "";

   typestring strtmp;
   strtmp.__stralloc((len>siz)?len:siz);
   __stralignright(strtmp.text,str.text,siz,fill);

   return strtmp;
}

//============================================================================
// strcheckspecs
//============================================================================
int strcheckspecs(const typestring& control){
   const int STATE_NORMAL = 1;
   const int STATE_FIRSTNUM = 2;
   const int STATE_STRING = 3;
   const int STATE_POINT = 4;
   const int STATE_DASH = 5;

   int state = STATE_NORMAL;
   int num1 = 0;
   int num2 = 0;
   int pos = 0;
   char *s = control.text;
   char c;

   do{
      c = (*s);
      pos = pos + 1;
      switch(state){
        case STATE_NORMAL:
           if ((c != '<') && (c != ' ') &&
               (c != '\0') && (c < '0' || c > '9')) return pos;
           if (c >= '0' && c <= '9'){
              state = STATE_FIRSTNUM;
              num1  = c - '0';
              num2  = 0;
           }
           if (c == '<') state = STATE_STRING;
           break;

        case STATE_FIRSTNUM:
           if ((c != '.') && (c != '-') && (c < '0' || c > '9')) return pos;
           if (c >= '0' && c <= '9') num1 = num1 * 10 + (c - '0');
           if (c == '.'){
              if (num1 <= 0) return pos;
              state = STATE_POINT;
           }
           if (c == '-'){
              if (num1 <= 0) return pos;
              state = STATE_DASH;
           }
           break;

        case STATE_STRING:
           if (c == '>') state = STATE_NORMAL;
           break;

        case STATE_POINT:
           if ((c != ' ') && (c != '\0') && (c < '0' || c > '9')) return pos;
           if (c >= '0' && c <= '9') num2 = num2 * 10 + (c - '0');
           else{
              if ((num1 <= 0)||(num2 <= 0)) return pos;
              state = STATE_NORMAL;
           }
           break;

        case STATE_DASH:
           if ((c != ' ') && (c != '\0') &&
               (c != '*') && (c < '0' || c > '9')) return pos;

           if (c >= '0' && c <= '9') num2 = num2 * 10 + (c - '0');
           if (c == '*' && num2 != 0) return pos;
           else{
              if (num1 <= 0) return pos;
              if ((c != '*') && (num1 > num2)) return pos;
              state = STATE_NORMAL;
           }
           break;
           
      }
      s++;
   } while(c != '\0');

   if (state == STATE_NORMAL) return 0;
   else return pos;
}

//============================================================================
// strmask
//============================================================================
int strmask(const typestring& str,const typestring& mask){
   if (str == "" | mask == "") return 0;
   return __strmask(str.text,mask.text);
}

//============================================================================
// strmatch
//============================================================================
int strmatch(const typestring& str,const typestring& pattern){

   if (__strlen(pattern.text) == 0) return 0;

   regex_t preg;
   int retcod = 0;

   if (regcomp(&preg,pattern.text,REG_EXTENDED | REG_NOSUB) == 0){
      retcod = (regexec(&preg,str.text,0,(regmatch_t *) NULL,0) == 0);
      regfree(&preg);
   }

   return retcod;
}






typestring strspecs(const typestring& str,const typestring& mask){
   typestring strtmp;
   //char *cstr  = str.text;
   char *cmask = mask.text;
   int num1,num2,op;

   while(*cmask){
      switch(*cmask){
         case ' ': cmask++;
                   break;

         case '<':
            cmask++;
            while((*cmask) != '>' && (*cmask)){
               strtmp = strtmp + (*cmask);
               cmask++;
            }
            if ((*cmask) == '>') cmask++;
            break;

         default :
            num1 = atoi(cmask);
            while(((*cmask) >= '0') && ((*cmask)<='9')) cmask++;

            op = (*cmask);
            cmask++;

            if ((*cmask) == '*'){
               strtmp = strtmp + strsub(str,num1);
               cmask++;
            }
            else{
               num2 = atoi(cmask);
               while(((*cmask) >= '0') && ((*cmask)<='9') && (*cmask)) cmask++;
               if (op == '.') strtmp = strtmp + strsub(str,num1,num2);
               else strtmp = strtmp + strsub(str,num1,num2-num1+1);
            }
      }
   }
   return strtmp;
}




typestring strcstyle(const typestring& str){
   char *s = str.text;
   int i = 0;
   int l = __strlen(s);
   typestring text = "";
   
   while(i < l){
      switch(s[i]){
         case 0x09: text = text + "\\t"; break;
         case 0x00: text = text + "\\0"; break;
         case '\\': text = text + "\\\\"; break;
         case '"' : text = text + "\\\""; break;
         default  : text = text + s[i]; break;
      }
      i = i + 1;
   }

   return text;
}


typestring strparse(const typestring& str,const typestring& strc,int index){
   int counter = 0;
   int pos;
   int is = 1;
   int ic = 1;
   int ls = strlength(str);
   int lc = strlength(strc);
   typestring strparm;
   typestring strcomp;

   while(ic <= lc && is <= ls){

     if (strsub(strc,ic,1) == '@'){
       counter = counter + 1;
       strparm = "";
       ic = ic + 1;
       if (ic > lc){
          strparm = strsub(str,is);
       }
       else{
          pos = strlocate(strsub(strc,ic),"@");
          if (pos == 0) strcomp = strsub(strc,ic);
          else strcomp = strsub(strc,ic,pos-1);
          while(is <= ls && strsub(str,is,strlength(strcomp)) != strcomp){
             strparm = strparm + strsub(str,is,1);
             is = is + 1;
          }
          if (is > ls) return "";
       }
       if (counter == index) return strparm;
     }
     else{
       if (strsub(str,is,1) != strsub(strc,ic,1)){
          return typestring("");
       }
       ic = ic + 1;
       is = is + 1;
     }
   }

   return typestring("");
}


#define MAXSTRINGF 1024   // Tamanho do char * de definicao em stringf
typestring stringf(const typestring& strformat,...){
   char *format = strformat.text;
   char *buffer = new char [MAXSTRINGF];
   va_list argptr;
   va_start(argptr,&strformat);
   vsprintf(buffer,format,argptr);
   va_end(argptr);
   typestring strtmp = buffer;
   delete [] buffer;
   return strtmp;
}





//============================================================================
// Basic built-in string functions
//============================================================================
static int __strlen(const char *p){
   int i = 0;
   while(*p != '\0') i++, p++;

   return i;
}
static void __strcpy(char *p,const char *po){
   while(*po != '\0'){
      *p = (*po);
      p++;
      po++;
   }
   *p = '\0';
}
static void __strncpy(char *p,const char *po,int n){
   while((*po != '\0') && (n > 0)){
      *p = (*po);
      p++;
      po++;
      n--;
   }
   *p = '\0';
}
static void __strcat(char *p,const char *po){
   while(*p != '\0') p++;

   while(*po != '\0'){
      *p = (*po);
      p++;
      po++;
   }
   *p = '\0';
}
static int __strcmp(const char *pa,const char *pb){
   while((*pa != '\0') && ((*pa) == (*pb))){
      pa++;
      pb++;
   }
   if ((*pa) > (*pb)) return 1;
   if ((*pa) < (*pb)) return -1;
   return 0;
}
static void __strupr(char *p){
   while(*p != '\0'){
      if (((*p) >= 'a') && ((*p) <= 'z')) *p = (*p) - 'a' + 'A';
      p++;
   }
}
static void __strlwr(char *p){
   while(*p != '\0'){
      if (((*p) >= 'A') && ((*p) <= 'Z')) *p = (*p) - 'A' + 'a';
      p++;
   }
}
static int __strind(const char *p,const char c){
   int i = 0;
   while(*p != '\0'){
      if ((*p) != c){
         p++;
         i++;
      }
      else return i + 1;
   }
   return 0;
}
static int __strloc(const char *p, const char *sub){
   int i = 0;
   const char *tp;
   const char *tsub;
   while (*p != '\0'){
      if ((*p) != (*sub)) i++;
      else {
         tp = p;
         tsub = sub;
         while((*tp != '\0' ) && ((*tp)==(*tsub))) tp++,tsub++;
         if (!(*tsub)) return i+1;
      }
      p++;
   }
   return 0;
}
static void __strdate(int *d,int *m,int *y){
   time_t data_t = time(0);
   struct tm *data_tm = localtime(&data_t);
   *d = data_tm->tm_mday;
   *m = data_tm->tm_mon+1;
   *y = data_tm->tm_year+1900;
}
static void __strtime(int *h,int *m,int *s){
   time_t data_t = time(0);
   struct tm *data_tm = localtime(&data_t);
   *h = data_tm->tm_hour;
   *m = data_tm->tm_min;
   *s = data_tm->tm_sec;
}
static int __strvfy(const char *p,const char *control){
   int pos = 1;
   const char *tc;

   while(*p != '\0'){
      tc = control;
      while((*tc) !=(*p) && (*tc) != '\0') tc++;
      if ((*tc) !=(*p)) return pos;
      p++;
      pos++;
   }
   return 0;
}
static void __stralignleft(char *p,const char *po,int siz,char fill){
   while(*po != '\0') *p = *po, p++, po++, siz--;
   while(siz > 0) *p = fill, p++, siz--;
   *p = '\0';
}
static void __stralignright(char *p,const char *po,int siz,char fill){
   int diff = siz; 
   const char *tpo = po;

   while(*tpo != '\0') diff--,tpo++;
   while(diff > 0) *p = fill, p++, diff--;
   while(*po != '\0') *p = *po, p++, po++;
   *p = '\0';
}    
static int __strmask(const char *str, const char *mask){
   char status = 0;
   const char *posi = NULL;

   while(*str != '\0' && *mask != '\0'){
      if (*mask == '*'){
         status = 1;
         mask++;
         posi = mask;
      }
      else if (*mask == '?'){
         str++;
         mask++;
      }
      else if ((*str) != (*mask)){
         if (status == 0) return 0;
         else {
            str++;
            mask = posi;
         }
      }
      else{
         str++;
         mask++;
      }
   }
   while(*mask == '*') mask++;
   if (*mask || *str) return 0;
   return 1;
}
static void __stritoa(char *p,int num){

   if (num < 0){
      *p = '-';
      p++;
      num = -num;
   }

   char c;
   char *pi = p;

   while(num > 0){
      *p = (num%10) + '0';
      p++;
      num = num / 10;
   }
   *p = '\0';

   p--;
   while(pi < p){
      c = *p;
      *p = *pi;
      *pi = c; 
      p--;
      pi++;
   }
}
