//============================================================================
// typestring -- objeto string nc_string -- by Eduardo Aguiar
//============================================================================
#ifndef def_typestring
#define def_typestring

class typestring {

private:
   char *text;

public:

//============================================================================
// Construtores e destrutor
//============================================================================
   typestring(void);
   typestring(int); 
   typestring(const char *);
   typestring(const char);
   typestring(const typestring &);
   ~typestring(void);

//============================================================================
// Operadores
//============================================================================
   typestring& operator = (const typestring&);

   friend typestring operator + (const typestring&,const typestring&);
   friend typestring operator + (const char *,const typestring&);
   friend typestring operator + (const char,const typestring&);
   friend typestring operator + (int,const typestring&);
   typestring operator += (const typestring&);
  
   friend int operator == (const typestring&,const typestring&);
   friend int operator != (const typestring&,const typestring&);
   friend int operator > (const typestring&,const typestring&);
   friend int operator < (const typestring&,const typestring&);
   friend int operator >= (const typestring&,const typestring&);
   friend int operator <= (const typestring&,const typestring&);

   friend const char *operator ! (const typestring&);
   friend const char *chars(const typestring&);

private:
   void __stralloc(int);

//============================================================================
// Funcoes friend
//============================================================================
public:
   friend int strtoint(const typestring&);
   friend int strlength(const typestring&);
   friend int strindex(const typestring&,char);
   friend int strlocate(const typestring&,const typestring&);
   friend int strcheckspecs(const typestring&);
   friend int strverify(const typestring&,const typestring&);
   friend int strmask(const typestring&,const typestring&);
   friend int strmatch(const typestring&,const typestring&);
   friend typestring strsub(const typestring&,int);
   friend typestring strsub(const typestring&,int,int);
   friend typestring strleft(const typestring&,int);
   friend typestring strright(const typestring&,int);
   friend typestring strupper(const typestring&);
   friend typestring strlower(const typestring&);
   friend typestring strdate(const typestring&);
   friend typestring strtime(void);
   friend typestring strstrip(const typestring&);
   friend typestring strlstrip(const typestring&);
   friend typestring strrstrip(const typestring&);
   friend typestring strsqueeze(const typestring&);
   friend typestring stralignleft(const typestring&,int,char = ' ');
   friend typestring stralignright(const typestring&,int,char = ' ');
   friend typestring strcopies(const typestring&,int);

   friend int strwords(const typestring&, const typestring& = ' ');
   friend typestring strword(const typestring&,int,const typestring& = " ");
   friend typestring strnword(const typestring&,int,const typestring& = " ");
   friend typestring stringf(const typestring&,...);
   friend typestring strparse(const typestring&,const typestring&,int);
   friend typestring strcstyle(const typestring&);
   friend typestring strspecs(const typestring&,const typestring&);

};

#endif
