/*2:*/
#line 7 "unicode.w"


#ifndef _UNICODE_H_
#define _UNICODE_H_

#ifdef __cplusplus
extern"C"{
#endif

#include <stdlib.h> 
#include <sys/types.h> 

typedef u_int16_t Uchar;




#if defined(_WIN32) && !defined(STATIC)
# if defined(BUILD)
#  define UNI_DL_IMPORT __declspec(dllexport)
# else
#  define UNI_DL_IMPORT __declspec(dllimport)
# endif
#else
# define UNI_DL_IMPORT
#endif


enum __Uerror{
U_ERR_ILLEGAL_CHARACTER,
U_ERR_MALFORMED_CHARACTER,
U_ERR_ALLOCATION_FAILED,
U_ERR_NONE
};

typedef enum __Uerror Uerror;

/*:2*//*3:*/
#line 62 "unicode.w"


typedef struct __Ufunctions{
void*(*calloc)(size_t,size_t);
void*(*realloc)(void*,size_t);
void(*free)(void*);
Uerror error;
}Ufunctions;

#ifdef _UNICODE_MAIN_
UNI_DL_IMPORT Ufunctions __ufunctions= {calloc,realloc,free,U_ERR_NONE};
#define Uerror __ufunctions.error
#else
UNI_DL_IMPORT extern Ufunctions __ufunctions;
#endif


/*:3*//*4:*/
#line 114 "unicode.w"


UNI_DL_IMPORT Uchar*uni_make(Ufunctions*,...);

#ifdef __GNUC__
#define u_make(args...) (uni_make(&__ufunctions , ## args))
#endif

/*:4*//*5:*/
#line 126 "unicode.w"


#ifdef __GNUC__
#define u_printf(fmt, args... ) (wprintf((fmt) , ## args ))
#define uni_printf(fmt, args... ) (wprintf((fmt) , ## args ))
#endif


/*:5*//*7:*/
#line 140 "unicode.w"

#define uni_isalnum(c) iswalnum((wchar_t)c)
#define uni_isalpha(c) iswalpha((wchar_t)c)
#define uni_isascii(c) iswascii((wchar_t)c)
#define uni_iscntrl(c) iswcntrl((wchar_t)c)
#define uni_isdigit(c) iswdigit((wchar_t)c)
#define uni_isgraph(c) iswgraph((wchar_t)c)
#define uni_islower(c) iswlower((wchar_t)c)
#define uni_isprint(c) iswprint((wchar_t)c)
#define uni_ispunct(c) iswpunct((wchar_t)c)
#define uni_isspace(c) iswspace((wchar_t)c)
#define uni_isupper(c) iswupper((wchar_t)c)
#define uni_isxdigit(c) iswxdigit((wchar_t)c)

#define u_isalnum(c) uni_isalnum(c)
#define u_isalpha(c) uni_isalpha(c)
#define u_isascii(c) uni_isascii(c)
#define u_iscntrl(c) uni_iscntrl(c)
#define u_isdigit(c) uni_isdigit(c)
#define u_isgraph(c) uni_isgraph(c)
#define u_islower(c) uni_islower(c)
#define u_isprint(c) uni_isprint(c)
#define u_ispunct(c) uni_ispunct(c)
#define u_isspace(c) uni_isspace(c)
#define u_isupper(c) uni_isupper(c)
#define u_isxdigit(c) uni_isxdigit(c)

/*:7*//*8:*/
#line 171 "unicode.w"



#ifdef HAVE_TOWLOWER
#define uni_tolower(c) ((Uchar)towlower((wchar_t)c))
#define uni_toupper(c) ((Uchar)towupper((wchar_t)c))
#else
#define uni_tolower(c) ((Uchar)tolower((wchar_t)c))
#define uni_toupper(c) ((Uchar)toupper((wchar_t)c))
#endif

#define uni_toascii(c) ((Uchar)c)

#define u_tolower(c) uni_tolower(c)
#define u_toupper(c) uni_toupper(c)
#define u_toascii(c) uni_toascii(c)
#define u__tolower(c) uni_tolower(c)
#define u__toupper(c) uni_toupper(c)


/*:8*//*10:*/
#line 197 "unicode.w"

#define uni_index(str, c) (uni_strchr((str), (c)))
#define u_index(str, c) (uni_index((str), (c)))

#define uni_rindex(str, c) (uni_strrchr((str), (c)))
#define u_rindex(str, c) (uni_rindex((str), (c)))
/*:10*//*11:*/
#line 207 "unicode.w"


UNI_DL_IMPORT int uni_strcasecmp(Uchar*,Uchar*);
#define u_strcasecmp(s1, s2) (uni_strcasecmp((s1), (s2)))

UNI_DL_IMPORT int uni_strncasecmp(Uchar*,Uchar*,size_t);
#define u_strncasecmp(s1, s2, n) (uni_strncasecmp((s1), (s2), (n)))


/*:11*//*12:*/
#line 222 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strcat(Ufunctions*,Uchar*,const Uchar*);
UNI_DL_IMPORT Uchar*u_strcat(Uchar*,const Uchar*);

UNI_DL_IMPORT Uchar*uni_strncat(Ufunctions*,Uchar*,const Uchar*,size_t);
UNI_DL_IMPORT Uchar*u_strncat(Uchar*,const Uchar*,size_t);

UNI_DL_IMPORT Uchar*uni_strappend(Ufunctions*,Uchar**,const Uchar*);
UNI_DL_IMPORT Uchar*u_strappend(Uchar**,const Uchar*);

UNI_DL_IMPORT Uchar*uni_strnappend(Ufunctions*,Uchar**,const Uchar*,size_t);
UNI_DL_IMPORT Uchar*u_strnappend(Uchar**,const Uchar*,size_t);

/*:12*//*13:*/
#line 240 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strchr(const Uchar*,Uchar);
#define u_strchr(str, c) (uni_strchr((str), (c)))

UNI_DL_IMPORT Uchar*uni_strrchr(const Uchar*,Uchar);
#define u_strrchr(str, c) (uni_strrchr((str), (c)))

/*:13*//*14:*/
#line 252 "unicode.w"


UNI_DL_IMPORT int uni_strcmp(Uchar*,Uchar*);
#define u_strcmp(s1, s2) (uni_strcmp((s1), (s1)))

UNI_DL_IMPORT int uni_strncmp(Uchar*,Uchar*,size_t);
#define u_strncmp(s1, s2, n) (uni_strncmp((s1), (s1), (n)))

/*:14*//*15:*/
#line 264 "unicode.w"


UNI_DL_IMPORT size_t uni_strspn(Uchar*,const Uchar*);
#define u_strspn(s, reject) (uni_strspn((s), (reject)))

UNI_DL_IMPORT size_t uni_strcspn(Uchar*,const Uchar*);
#define u_strcspn(s, accept) (uni_strcspn((s), (accept)))

/*:15*//*16:*/
#line 278 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strdup(Ufunctions*,const Uchar*);
UNI_DL_IMPORT Uchar*u_strdup(const Uchar*);

UNI_DL_IMPORT Uchar*uni_strndup(Ufunctions*,const Uchar*,size_t);
UNI_DL_IMPORT Uchar*u_strndup(const Uchar*,size_t);

/*:16*//*17:*/
#line 291 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strcpy(Uchar*,const Uchar*);
UNI_DL_IMPORT Uchar*u_strcpy(Uchar*,const Uchar*);

UNI_DL_IMPORT Uchar*uni_strncpy(Uchar*,const Uchar*,size_t);
UNI_DL_IMPORT Uchar*u_strncpy(Uchar*,const Uchar*,size_t);

/*:17*//*18:*/
#line 304 "unicode.w"


UNI_DL_IMPORT size_t uni_strlen(const Uchar*);
#define u_strlen(str) (uni_strlen((str)))

/*:18*//*19:*/
#line 313 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strpbrk(const Uchar*,const Uchar*);
#define u_strpbrk(str, accept) (uni_strpbrk((str), (accept)))

/*:19*//*20:*/
#line 322 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strsep(Ufunctions*,Uchar**,Uchar*);
#define u_strsep(str, delim) (uni_strsep(&__ufunctions, (str), (delim)))

/*:20*//*21:*/
#line 331 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strstr(Uchar*,Uchar*);
#define u_strstr(haystack, needle) (uni_strstr((haystack), (needle)))

/*:21*//*22:*/
#line 340 "unicode.w"


UNI_DL_IMPORT Uchar*uni_strtok(Uchar*str,const Uchar*delim);
#define u_strtok(str, delim) (uni_strtok((str), (delim)))


/*:22*//*23:*/
#line 350 "unicode.w"


UNI_DL_IMPORT Uchar*uni_utf8_to_uc(Ufunctions*,char*);

#define u_utf8_to_uc(str) (uni_utf8_to_uc(&__ufunctions, (str)))

/*:23*//*24:*/
#line 360 "unicode.w"


UNI_DL_IMPORT char*uni_uc_to_utf8(Ufunctions*,Uchar*);
#define u_uc_to_utf8(str) (uni_uc_to_utf8(&__ufunctions, (str)))

/*:24*//*25:*/
#line 371 "unicode.w"


#ifdef _UNICODE_MAIN_

UNI_DL_IMPORT Uchar U_END_ELEM_NOCONT[]= {0xFEFF,' ','/','>','\0'};
UNI_DL_IMPORT Uchar U_END_ELEM[]= {0xFEFF,'<','/','\0'};
UNI_DL_IMPORT Uchar U_EQ_QUOT[]= {0xFEFF,'=','\"','\0'};
UNI_DL_IMPORT Uchar U_CDATA[]= {0xFEFF,'<','!','[','C','D','A','T','A','[',' ',
'\0'};
UNI_DL_IMPORT Uchar U_END_CDATA[]= {0xFEFF,']',']','>','\0'};
UNI_DL_IMPORT Uchar U_ENT[]= {0xFEFF,'<','!','E','N','T','I','T','Y',' ','\0'};
UNI_DL_IMPORT Uchar U_PI[]= {0xFEFF,'<','?','\0'};
UNI_DL_IMPORT Uchar U_END_PI[]= {0xFEFF,'?','>','\0'};
UNI_DL_IMPORT Uchar U_COMM[]= {0xFEFF,'<','!','-','-','\0'};
UNI_DL_IMPORT Uchar U_END_COMM[]= {0xFEFF,'-','-','>','\0'};
UNI_DL_IMPORT Uchar U_DOCTYPE[]= {0xFEFF,'<','!','D','O','C','T','Y','P','E',' ',
'\0'};
UNI_DL_IMPORT Uchar U_NOTATION[]= {0xFEFF,'<','!','N','O','T','A','T','I','O','N',
' ','\0'};
UNI_DL_IMPORT Uchar U_DEFAULT_PROLOG[]= {0xFEFF,'<','?','x','m','l',' ',
'v','e','r','s','i','o','n','=','"','1','.','0','"',' ',
'e','n','c','o','d','i','n','g','=','"','u','t','f','-','8','"',' ','?','>','\0'};

#else

UNI_DL_IMPORT extern Uchar U_END_ELEM_NOCONT[5];
UNI_DL_IMPORT extern Uchar U_END_ELEM[4];
UNI_DL_IMPORT extern Uchar U_EQ_QUOT[4];
UNI_DL_IMPORT extern Uchar U_CDATA[12];
UNI_DL_IMPORT extern Uchar U_END_CDATA[5];
UNI_DL_IMPORT extern Uchar U_ENT[11];
UNI_DL_IMPORT extern Uchar U_PI[4];
UNI_DL_IMPORT extern Uchar U_END_PI[4];
UNI_DL_IMPORT extern Uchar U_COMM[6];
UNI_DL_IMPORT extern Uchar U_END_COMM[5];
UNI_DL_IMPORT extern Uchar U_DOCTYPE[12];
UNI_DL_IMPORT extern Uchar U_NOTATION[13];
UNI_DL_IMPORT extern Uchar U_DEFAULT_PROLOG[41];

#endif 

/*:25*//*26:*/
#line 416 "unicode.w"


#ifdef _UNICODE_MAIN_

UNI_DL_IMPORT Uchar U_SP[]= {0xFEFF,0x20,0};
UNI_DL_IMPORT Uchar U_QUOT[]= {0xFEFF,0x22,0};
UNI_DL_IMPORT Uchar U_AMP[]= {0xFEFF,0x26,0};
UNI_DL_IMPORT Uchar U_SEMICOL[]= {0xFEFF,0x3B,0};
UNI_DL_IMPORT Uchar U_LT[]= {0xFEFF,0x3C,0};
UNI_DL_IMPORT Uchar U_GT[]= {0xFEFF,0x3E,0};

#else

UNI_DL_IMPORT extern Uchar U_SP[3];
UNI_DL_IMPORT extern Uchar U_QUOT[3];
UNI_DL_IMPORT extern Uchar U_AMP[3];
UNI_DL_IMPORT extern Uchar U_SEMICOL[3];
UNI_DL_IMPORT extern Uchar U_LT[3];
UNI_DL_IMPORT extern Uchar U_GT[3];

#endif 

#ifdef __cplusplus
}
#endif

#endif 

/*:26*/
