/*2:*/
#line 7 "uni_uc_to_utf8.w"


#include <unicode.h> 

char*
uni_uc_to_utf8(Ufunctions*ufunct,Uchar*src){
char*ret= NULL;
char*old_ret= NULL;
int ret_len= 0;

ufunct->error= U_ERR_NONE;

if(!src)
return NULL;

src++;

/*3:*/
#line 44 "uni_uc_to_utf8.w"


while(*src){

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}

if(*src<0x20&&*src!=0x9&&*src!=0xA&&*src!=0xD){
/*8:*/
#line 198 "uni_uc_to_utf8.w"


ret[ret_len-1]= '\0';
ufunct->error= U_ERR_ILLEGAL_CHARACTER;

return ret;

/*:8*/
#line 58 "uni_uc_to_utf8.w"
;
}else if(*src<0x80){
/*4:*/
#line 80 "uni_uc_to_utf8.w"


ret[ret_len-1]= *src++;

/*:4*/
#line 60 "uni_uc_to_utf8.w"
;
}else if(*src<0x0800){
/*5:*/
#line 89 "uni_uc_to_utf8.w"

{
Uchar tmp_src= *src++;

ret[ret_len-1]= tmp_src&0x1F;
ret[ret_len-1]|= 0xC0;

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}
tmp_src>>= 5;

ret[ret_len-1]= tmp_src&0x3F;
ret[ret_len-1]|= 0x80;
}

/*:5*/
#line 62 "uni_uc_to_utf8.w"
;
}else if(*src<0xD800){
/*6:*/
#line 114 "uni_uc_to_utf8.w"

{
Uchar tmp_src= *src++;

ret[ret_len-1]= tmp_src&0x0F;
ret[ret_len-1]|= 0xE0;

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}
tmp_src>>= 4;

ret[ret_len-1]= tmp_src&0x3F;
ret[ret_len-1]|= 0x80;

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}
tmp_src>>= 6;

ret[ret_len-1]= tmp_src&0x3F;
ret[ret_len-1]|= 0x80;
}

/*:6*/
#line 64 "uni_uc_to_utf8.w"
;
}else if(*src<0xDC00){
/*7:*/
#line 157 "uni_uc_to_utf8.w"

{
unsigned int ucs;

if(*(src+1)<0xDC00||*(src+1)> 0xDFFF){
/*9:*/
#line 210 "uni_uc_to_utf8.w"


ret[ret_len-1]= '\0';
ufunct->error= U_ERR_MALFORMED_CHARACTER;

return ret;

/*:9*/
#line 162 "uni_uc_to_utf8.w"
;
}

ucs= ((*src++-0xD800)*0x0400)+(*src++-0xDC00)+0x010000;

ret_len+= 4;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-5]= '\0';
return old_ret;
}

ret[ret_len-1]= ucs&0x3F;
ret[ret_len-1]|= 0x80;
ucs>>= 6;

ret[ret_len-2]= ucs&0x3F;
ret[ret_len-2]|= 0x80;
ucs>>= 6;

ret[ret_len-3]= ucs&0x3F;
ret[ret_len-3]|= 0x80;
ucs>>= 6;

ret[ret_len-4]= ucs&0x07;
ret[ret_len-4]|= 0xF0;

}

/*:7*/
#line 66 "uni_uc_to_utf8.w"
;
}else if(*src<0xE000){
/*9:*/
#line 210 "uni_uc_to_utf8.w"


ret[ret_len-1]= '\0';
ufunct->error= U_ERR_MALFORMED_CHARACTER;

return ret;

/*:9*/
#line 68 "uni_uc_to_utf8.w"
;
}else if(*src<0x110000){
/*6:*/
#line 114 "uni_uc_to_utf8.w"

{
Uchar tmp_src= *src++;

ret[ret_len-1]= tmp_src&0x0F;
ret[ret_len-1]|= 0xE0;

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}
tmp_src>>= 4;

ret[ret_len-1]= tmp_src&0x3F;
ret[ret_len-1]|= 0x80;

ret_len++;
old_ret= ret;
ret= ufunct->realloc(ret,ret_len*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-2]= '\0';
return old_ret;
}
tmp_src>>= 6;

ret[ret_len-1]= tmp_src&0x3F;
ret[ret_len-1]|= 0x80;
}

/*:6*/
#line 70 "uni_uc_to_utf8.w"
;
}else{
/*8:*/
#line 198 "uni_uc_to_utf8.w"


ret[ret_len-1]= '\0';
ufunct->error= U_ERR_ILLEGAL_CHARACTER;

return ret;

/*:8*/
#line 72 "uni_uc_to_utf8.w"

}
}

/*:3*/
#line 24 "uni_uc_to_utf8.w"
;

old_ret= ret;
ret= ufunct->realloc(ret,(ret_len+1)*sizeof(char));
if(!ret){
ufunct->error= U_ERR_ALLOCATION_FAILED;
old_ret[ret_len-1]= '\0';
return old_ret;
}

ret[ret_len]= '\0';

return ret;
}

/*:2*/
