
@i ../copyright.w

@* uni\_strsep.

Returns next token from string pointed by |strp|, using characters
from |set| as delimiters (delimiter is changed (in place) to NULL character).
Variable pointed by |strp| is updated for next call to |uni\_strsep|.
When there is no more tokens left, NULL is returned. 

@c

#include <unicode.h>

Uchar*
uni_strsep(Ufunctions *uf, Uchar **strp, Uchar *set){

        Uchar *p=*strp;
        Uchar *token;

        if (!p) return NULL;

        token=p;

        while (*p)
        {
          if (uni_strchr(set,*p))
          {
            *p++=0; break;
          }
          p++;
        }

        if (!*p) *strp=NULL;
        else     *strp=p;

        return token;
}

@* Index.